/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.DemographicsDistributions;
import io.trino.tpcds.generator.IncomeBandGeneratorColumn;
import io.trino.tpcds.row.IncomeBandRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;

public class IncomeBandRowGenerator
extends AbstractRowGenerator {
    public IncomeBandRowGenerator() {
        super(Table.INCOME_BAND);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.INCOME_BAND, this.getRandomNumberStream(IncomeBandGeneratorColumn.IB_NULLS));
        int ibIncomeBandId = (int)rowNumber;
        int ibLowerBound = DemographicsDistributions.getIncomeBandLowerBoundAtIndex((int)rowNumber - 1);
        int ibUpperBound = DemographicsDistributions.getIncomeBandUpperBoundAtIndex((int)rowNumber - 1);
        return new RowGeneratorResult(new IncomeBandRow(nullBitMap, ibIncomeBandId, ibLowerBound, ibUpperBound));
    }
}

