/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import com.google.common.collect.ImmutableList;
import io.trino.tpcds.JoinKeyUtils;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Scaling;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.generator.StoreReturnsGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.StoreReturnsRow;
import io.trino.tpcds.row.StoreSalesRow;
import io.trino.tpcds.row.TableRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Pricing;
import java.util.Collections;
import java.util.List;

public class StoreReturnsRowGenerator
extends AbstractRowGenerator {
    private static final int SR_SAME_CUSTOMER = 80;

    public StoreReturnsRowGenerator() {
        super(Table.STORE_RETURNS);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        RowGeneratorResult salesAndReturnsResult = parentRowGenerator.generateRowAndChildRows(rowNumber, session, null, this);
        if (salesAndReturnsResult.getRowAndChildRows().size() == 2) {
            return new RowGeneratorResult((List<TableRow>)ImmutableList.of((Object)salesAndReturnsResult.getRowAndChildRows().get(1)), salesAndReturnsResult.shouldEndRow());
        }
        return new RowGeneratorResult(Collections.emptyList(), salesAndReturnsResult.shouldEndRow());
    }

    public TableRow generateRow(Session session, StoreSalesRow salesRow) {
        long nullBitMap = Nulls.createNullBitMap(Table.STORE_RETURNS, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_NULLS));
        long srTicketNumber = salesRow.getSsTicketNumber();
        long srItemSk = salesRow.getSsSoldItemSk();
        Scaling scaling = session.getScaling();
        long srCustomerSk = JoinKeyUtils.generateJoinKey(StoreReturnsGeneratorColumn.SR_CUSTOMER_SK, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_CUSTOMER_SK), Table.CUSTOMER, 1L, scaling);
        int randomInt = RandomValueGenerator.generateUniformRandomInt(1, 100, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_TICKET_NUMBER));
        if (randomInt < 80) {
            srCustomerSk = salesRow.getSsSoldCustomerSk();
        }
        long srReturnedDateSk = JoinKeyUtils.generateJoinKey(StoreReturnsGeneratorColumn.SR_RETURNED_DATE_SK, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_RETURNED_DATE_SK), Table.DATE_DIM, salesRow.getSsSoldDateSk(), scaling);
        long srReturnedTimeSk = RandomValueGenerator.generateUniformRandomInt(28799, 61199, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_RETURNED_TIME_SK));
        long srCdemoSk = JoinKeyUtils.generateJoinKey(StoreReturnsGeneratorColumn.SR_CDEMO_SK, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_CDEMO_SK), Table.CUSTOMER_DEMOGRAPHICS, 1L, scaling);
        long srHdemoSk = JoinKeyUtils.generateJoinKey(StoreReturnsGeneratorColumn.SR_HDEMO_SK, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_HDEMO_SK), Table.HOUSEHOLD_DEMOGRAPHICS, 1L, scaling);
        long srAddrSk = JoinKeyUtils.generateJoinKey(StoreReturnsGeneratorColumn.SR_ADDR_SK, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_ADDR_SK), Table.CUSTOMER_ADDRESS, 1L, scaling);
        long srStoreSk = JoinKeyUtils.generateJoinKey(StoreReturnsGeneratorColumn.SR_STORE_SK, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_STORE_SK), Table.STORE, 1L, scaling);
        long srReasonSk = JoinKeyUtils.generateJoinKey(StoreReturnsGeneratorColumn.SR_REASON_SK, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_REASON_SK), Table.REASON, 1L, scaling);
        Pricing salesPricing = salesRow.getSsPricing();
        int quantity = RandomValueGenerator.generateUniformRandomInt(1, salesPricing.getQuantity(), this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_PRICING));
        Pricing srPricing = Pricing.generatePricingForReturnsTable(StoreReturnsGeneratorColumn.SR_PRICING, this.getRandomNumberStream(StoreReturnsGeneratorColumn.SR_PRICING), quantity, salesPricing);
        return new StoreReturnsRow(nullBitMap, srReturnedDateSk, srReturnedTimeSk, srItemSk, srCustomerSk, srCdemoSk, srHdemoSk, srAddrSk, srStoreSk, srReasonSk, srTicketNumber, srPricing);
    }
}

