/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.htrace.core;

import io.trino.hadoop.$internal.htrace.core.HTraceConfiguration;
import io.trino.hadoop.$internal.htrace.core.SpanReceiver;
import io.trino.hadoop.$internal.htrace.core.Tracer;
import io.trino.hadoop.$internal.htrace.shaded.commons.logging.Log;
import io.trino.hadoop.$internal.htrace.shaded.commons.logging.LogFactory;
import java.util.Arrays;
import java.util.HashSet;

public class TracerPool {
    private static final Log LOG = LogFactory.getLog(TracerPool.class);
    static final TracerPool GLOBAL = new TracerPool("Global");
    private final String name;
    private volatile SpanReceiver[] curReceivers;
    private SpanReceiverShutdownHook shutdownHook;
    private final HashSet<Tracer> curTracers;

    public static TracerPool getGlobalTracerPool() {
        return GLOBAL;
    }

    public TracerPool(String name) {
        this.name = name;
        this.shutdownHook = null;
        this.curTracers = new HashSet();
        this.curReceivers = new SpanReceiver[0];
    }

    public String getName() {
        return this.name;
    }

    public SpanReceiver[] getReceivers() {
        return this.curReceivers;
    }

    public synchronized boolean addReceiver(SpanReceiver receiver) {
        SpanReceiver[] receivers = this.curReceivers;
        for (int i = 0; i < receivers.length; ++i) {
            if (receivers[i] != receiver) continue;
            LOG.trace(this.toString() + ": can't add receiver " + receiver.toString() + " since it is already in this pool.");
            return false;
        }
        SpanReceiver[] newReceivers = Arrays.copyOf(receivers, receivers.length + 1);
        newReceivers[receivers.length] = receiver;
        this.registerShutdownHookIfNeeded();
        this.curReceivers = newReceivers;
        LOG.trace(this.toString() + ": added receiver " + receiver.toString());
        return true;
    }

    private synchronized void registerShutdownHookIfNeeded() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = new SpanReceiverShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        LOG.trace(this.toString() + ": registered shutdown hook.");
    }

    public synchronized boolean removeReceiver(SpanReceiver receiver) {
        SpanReceiver[] receivers = this.curReceivers;
        for (int i = 0; i < receivers.length; ++i) {
            if (receivers[i] != receiver) continue;
            SpanReceiver[] newReceivers = new SpanReceiver[receivers.length - 1];
            System.arraycopy(receivers, 0, newReceivers, 0, i);
            System.arraycopy(receivers, i + 1, newReceivers, i, receivers.length - i - 1);
            this.curReceivers = newReceivers;
            LOG.trace(this.toString() + ": removed receiver " + receiver.toString());
            return true;
        }
        LOG.trace(this.toString() + ": can't remove receiver " + receiver.toString() + " since it's not currently in this pool.");
        return false;
    }

    public boolean removeAndCloseReceiver(SpanReceiver receiver) {
        if (!this.removeReceiver(receiver)) {
            return false;
        }
        try {
            LOG.trace(this.toString() + ": closing receiver " + receiver.toString());
            receiver.close();
        }
        catch (Throwable t) {
            LOG.error(this.toString() + ": error closing " + receiver.toString(), t);
        }
        return true;
    }

    private synchronized void removeAndCloseAllSpanReceivers() {
        SpanReceiver[] receivers = this.curReceivers;
        this.curReceivers = new SpanReceiver[0];
        for (SpanReceiver receiver : receivers) {
            try {
                LOG.trace(this.toString() + ": closing receiver " + receiver.toString());
                receiver.close();
            }
            catch (Throwable t) {
                LOG.error(this.toString() + ": error closing " + receiver.toString(), t);
            }
        }
    }

    public synchronized SpanReceiver loadReceiverType(String className, HTraceConfiguration conf, ClassLoader classLoader) {
        SpanReceiver[] receivers;
        String receiverClass = className.contains(".") ? className : "io.trino.hadoop.$internal.htrace.core." + className;
        for (SpanReceiver receiver : receivers = this.curReceivers) {
            if (!receiver.getClass().getName().equals(receiverClass)) continue;
            LOG.trace(this.toString() + ": returning a reference to receiver " + receiver.toString());
            return receiver;
        }
        LOG.trace(this.toString() + ": creating a new SpanReceiver of type " + className);
        SpanReceiver receiver = new SpanReceiver.Builder(conf).className(className).classLoader(classLoader).build();
        this.addReceiver(receiver);
        return receiver;
    }

    public synchronized Tracer[] getTracers() {
        return this.curTracers.toArray(new Tracer[this.curTracers.size()]);
    }

    synchronized void addTracer(Tracer tracer) {
        if (this.curTracers.add(tracer)) {
            LOG.trace(this.toString() + ": adding tracer " + tracer.toString());
        }
    }

    synchronized void removeTracer(Tracer tracer) {
        if (this.curTracers.remove(tracer)) {
            LOG.trace(this.toString() + ": removing tracer " + tracer.toString());
            if (this.curTracers.size() == 0) {
                this.removeAndCloseAllSpanReceivers();
            }
        }
    }

    public String toString() {
        return "TracerPool(" + this.name + ")";
    }

    private class SpanReceiverShutdownHook
    extends Thread {
        SpanReceiverShutdownHook() {
            this.setName("SpanReceiverShutdownHook");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            TracerPool.this.removeAndCloseAllSpanReceivers();
        }
    }
}

