/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.apache.commons.lang3.builder.EqualsBuilder;
import io.trino.hadoop.$internal.org.apache.commons.lang3.builder.HashCodeBuilder;
import java.io.Serializable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;

@InterfaceAudience.Private
public class ErasureCodingPolicyInfo
implements Serializable {
    private static final long serialVersionUID = 49L;
    private final ErasureCodingPolicy policy;
    private ErasureCodingPolicyState state;

    public ErasureCodingPolicyInfo(ErasureCodingPolicy thePolicy, ErasureCodingPolicyState theState) {
        Preconditions.checkNotNull(thePolicy);
        Preconditions.checkNotNull(theState);
        this.policy = thePolicy;
        this.state = theState;
    }

    public ErasureCodingPolicyInfo(ErasureCodingPolicy thePolicy) {
        this(thePolicy, ErasureCodingPolicyState.DISABLED);
    }

    public ErasureCodingPolicy getPolicy() {
        return this.policy;
    }

    public ErasureCodingPolicyState getState() {
        return this.state;
    }

    public void setState(ErasureCodingPolicyState newState) {
        Preconditions.checkNotNull(newState, "New state should not be null.");
        this.state = newState;
    }

    public boolean isEnabled() {
        return this.state == ErasureCodingPolicyState.ENABLED;
    }

    public boolean isDisabled() {
        return this.state == ErasureCodingPolicyState.DISABLED;
    }

    public boolean isRemoved() {
        return this.state == ErasureCodingPolicyState.REMOVED;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ErasureCodingPolicyInfo rhs = (ErasureCodingPolicyInfo)o;
        return new EqualsBuilder().append(this.policy, rhs.policy).append((Object)this.state, (Object)rhs.state).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(303855623, 582626729).append(this.policy).append((Object)this.state).toHashCode();
    }

    public String toString() {
        return this.policy.toString() + ", State=" + this.state.toString();
    }
}

