/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RamDiskReplicaTracker {
    static final Logger LOG = LoggerFactory.getLogger(RamDiskReplicaTracker.class);
    FsDatasetImpl fsDataset;

    static RamDiskReplicaTracker getInstance(Configuration conf, FsDatasetImpl fsDataset) {
        Class<RamDiskReplicaTracker> trackerClass = conf.getClass("dfs.datanode.ram.disk.replica.tracker", DFSConfigKeys.DFS_DATANODE_RAM_DISK_REPLICA_TRACKER_DEFAULT, RamDiskReplicaTracker.class);
        RamDiskReplicaTracker tracker = ReflectionUtils.newInstance(trackerClass, conf);
        tracker.initialize(fsDataset);
        return tracker;
    }

    void initialize(FsDatasetImpl fsDataset) {
        this.fsDataset = fsDataset;
    }

    abstract void addReplica(String var1, long var2, FsVolumeImpl var4, long var5);

    abstract void touch(String var1, long var2);

    abstract RamDiskReplica dequeueNextReplicaToPersist();

    abstract void reenqueueReplicaNotPersisted(RamDiskReplica var1);

    abstract void recordStartLazyPersist(String var1, long var2, FsVolumeImpl var4);

    abstract void recordEndLazyPersist(String var1, long var2, File[] var4);

    abstract RamDiskReplica getNextCandidateForEviction();

    abstract int numReplicasNotPersisted();

    abstract void discardReplica(String var1, long var2, boolean var4);

    abstract RamDiskReplica getReplica(String var1, long var2);

    static class RamDiskReplica
    implements Comparable<RamDiskReplica> {
        private final String bpid;
        private final long blockId;
        private File savedBlockFile;
        private File savedMetaFile;
        private long lockedBytesReserved;
        private long creationTime;
        protected AtomicLong numReads = new AtomicLong(0L);
        protected boolean isPersisted;
        final FsVolumeSpi ramDiskVolume;
        FsVolumeImpl lazyPersistVolume;

        RamDiskReplica(String bpid, long blockId, FsVolumeImpl ramDiskVolume, long lockedBytesReserved) {
            this.bpid = bpid;
            this.blockId = blockId;
            this.ramDiskVolume = ramDiskVolume;
            this.lockedBytesReserved = lockedBytesReserved;
            this.lazyPersistVolume = null;
            this.savedMetaFile = null;
            this.savedBlockFile = null;
            this.creationTime = Time.monotonicNow();
            this.isPersisted = false;
        }

        long getBlockId() {
            return this.blockId;
        }

        String getBlockPoolId() {
            return this.bpid;
        }

        FsVolumeImpl getLazyPersistVolume() {
            return this.lazyPersistVolume;
        }

        void setLazyPersistVolume(FsVolumeImpl volume) {
            Preconditions.checkState(!volume.isTransientStorage());
            this.lazyPersistVolume = volume;
        }

        File getSavedBlockFile() {
            return this.savedBlockFile;
        }

        File getSavedMetaFile() {
            return this.savedMetaFile;
        }

        long getNumReads() {
            return this.numReads.get();
        }

        long getCreationTime() {
            return this.creationTime;
        }

        boolean getIsPersisted() {
            return this.isPersisted;
        }

        void recordSavedBlockFiles(File[] files) {
            this.savedMetaFile = files[0];
            this.savedBlockFile = files[1];
        }

        public int hashCode() {
            return this.bpid.hashCode() ^ (int)this.blockId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RamDiskReplica otherState = (RamDiskReplica)other;
            return otherState.bpid.equals(this.bpid) && otherState.blockId == this.blockId;
        }

        void deleteSavedFiles() {
            if (this.savedBlockFile != null) {
                if (!this.savedBlockFile.delete()) {
                    LOG.warn("Failed to delete block file " + this.savedBlockFile);
                }
                this.savedBlockFile = null;
            }
            if (this.savedMetaFile != null) {
                if (!this.savedMetaFile.delete()) {
                    LOG.warn("Failed to delete meta file " + this.savedMetaFile);
                }
                this.savedMetaFile = null;
            }
        }

        @Override
        public int compareTo(RamDiskReplica other) {
            int bpidResult = this.bpid.compareTo(other.bpid);
            if (bpidResult == 0) {
                if (this.blockId == other.blockId) {
                    return 0;
                }
                if (this.blockId < other.blockId) {
                    return -1;
                }
                return 1;
            }
            return bpidResult;
        }

        public String toString() {
            return "[BlockPoolID=" + this.bpid + "; BlockId=" + this.blockId + "]";
        }

        public long getLockedBytesReserved() {
            return this.lockedBytesReserved;
        }
    }
}

