/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.inject.Inject;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.trino.plugin.base.security.FileBasedAccessControlConfig;
import io.trino.plugin.base.security.ForAccessControlRules;
import io.trino.plugin.base.util.JsonUtils;
import java.net.URI;
import java.util.Objects;

public class HttpBasedAccessControlRulesProvider {
    private final HttpClient httpClient;
    private final URI configUri;
    private final String jsonPointer;

    @Inject
    public HttpBasedAccessControlRulesProvider(@ForAccessControlRules HttpClient httpClient, FileBasedAccessControlConfig config) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.configUri = URI.create(config.getConfigFile());
        this.jsonPointer = config.getJsonPointer();
    }

    public <R> R extract(Class<R> clazz) {
        return JsonUtils.parseJson(this.getRawJsonString(), this.jsonPointer, clazz);
    }

    private String getRawJsonString() {
        Request request = Request.Builder.prepareGet().setUri(this.configUri).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        int status = response.getStatusCode();
        if (status != HttpStatus.OK.code()) {
            throw new IllegalStateException(String.format("Request to '%s' returned unexpected status code: '%d'", this.configUri, status));
        }
        return response.getBody();
    }
}

