/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.batch;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClientBuilder;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.batch.BlobBatchOperation;
import com.azure.storage.blob.batch.BlobBatchOperationInfo;
import com.azure.storage.blob.batch.BlobBatchOperationResponse;
import com.azure.storage.blob.batch.BlobBatchType;
import com.azure.storage.blob.batch.options.BlobBatchSetBlobAccessTierOptions;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.RehydratePriority;
import com.azure.storage.blob.options.BlobSetAccessTierOptions;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedDeque;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public final class BlobBatch {
    private static final String X_MS_VERSION = "x-ms-version";
    private static final String BATCH_REQUEST_URL_PATH = "Batch-Request-Url-Path";
    private static final String BATCH_OPERATION_RESPONSE = "Batch-Operation-Response";
    private static final String BATCH_OPERATION_INFO = "Batch-Operation-Info";
    private static final String PATH_TEMPLATE = "%s/%s";
    private static final int[] EXPECTED_DELETE_STATUS_CODES = new int[]{202};
    private static final int[] EXPECTED_SET_TIER_STATUS_CODES = new int[]{200, 202};
    private final ClientLogger logger = new ClientLogger(BlobBatch.class);
    private final BlobAsyncClient blobAsyncClient;
    private Deque<BlobBatchOperation<?>> batchOperationQueue;
    private BlobBatchType batchType;

    BlobBatch(String accountUrl, HttpPipeline pipeline, BlobServiceVersion serviceVersion) {
        boolean batchHeadersPolicySet = false;
        HttpPipelineBuilder batchPipelineBuilder = new HttpPipelineBuilder();
        for (int i = 0; i < pipeline.getPolicyCount(); ++i) {
            HttpPipelinePolicy policy = pipeline.getPolicy(i);
            if (policy instanceof StorageSharedKeyCredentialPolicy) {
                batchHeadersPolicySet = true;
                batchPipelineBuilder.policies(new HttpPipelinePolicy[]{this::cleanseHeaders, this::setRequestUrl});
            }
            batchPipelineBuilder.policies(new HttpPipelinePolicy[]{policy});
        }
        if (!batchHeadersPolicySet) {
            batchPipelineBuilder.policies(new HttpPipelinePolicy[]{this::cleanseHeaders, this::setRequestUrl});
        }
        batchPipelineBuilder.policies(new HttpPipelinePolicy[]{this::buildBatchOperation});
        batchPipelineBuilder.httpClient(pipeline.getHttpClient());
        this.blobAsyncClient = new BlobClientBuilder().endpoint(accountUrl).blobName("").serviceVersion(serviceVersion).pipeline(batchPipelineBuilder.build()).buildAsyncClient();
        this.batchOperationQueue = new ConcurrentLinkedDeque();
    }

    public Response<Void> deleteBlob(String containerName, String blobName) {
        return this.deleteBlobHelper(String.format(PATH_TEMPLATE, containerName, Utility.urlEncode((String)Utility.urlDecode((String)blobName))), null, null);
    }

    public Response<Void> deleteBlob(String containerName, String blobName, DeleteSnapshotsOptionType deleteOptions, BlobRequestConditions blobRequestConditions) {
        return this.deleteBlobHelper(String.format(PATH_TEMPLATE, containerName, Utility.urlEncode((String)Utility.urlDecode((String)blobName))), deleteOptions, blobRequestConditions);
    }

    public Response<Void> deleteBlob(String blobUrl) {
        return this.deleteBlobHelper(this.getUrlPath(blobUrl), null, null);
    }

    public Response<Void> deleteBlob(String blobUrl, DeleteSnapshotsOptionType deleteOptions, BlobRequestConditions blobRequestConditions) {
        return this.deleteBlobHelper(this.getUrlPath(blobUrl), deleteOptions, blobRequestConditions);
    }

    private Response<Void> deleteBlobHelper(String urlPath, DeleteSnapshotsOptionType deleteOptions, BlobRequestConditions blobRequestConditions) {
        this.setBatchType(BlobBatchType.DELETE);
        return this.createBatchOperation(this.blobAsyncClient.deleteWithResponse(deleteOptions, blobRequestConditions), urlPath, EXPECTED_DELETE_STATUS_CODES);
    }

    public Response<Void> setBlobAccessTier(String containerName, String blobName, AccessTier accessTier) {
        return this.setBlobAccessTierHelper(String.format(PATH_TEMPLATE, containerName, Utility.urlEncode((String)Utility.urlDecode((String)blobName))), accessTier, null, null, null);
    }

    public Response<Void> setBlobAccessTier(String containerName, String blobName, AccessTier accessTier, String leaseId) {
        return this.setBlobAccessTierHelper(String.format(PATH_TEMPLATE, containerName, Utility.urlEncode((String)Utility.urlDecode((String)blobName))), accessTier, null, leaseId, null);
    }

    public Response<Void> setBlobAccessTier(String blobUrl, AccessTier accessTier) {
        return this.setBlobAccessTierHelper(this.getUrlPath(blobUrl), accessTier, null, null, null);
    }

    public Response<Void> setBlobAccessTier(String blobUrl, AccessTier accessTier, String leaseId) {
        return this.setBlobAccessTierHelper(this.getUrlPath(blobUrl), accessTier, null, leaseId, null);
    }

    public Response<Void> setBlobAccessTier(BlobBatchSetBlobAccessTierOptions options) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        return this.setBlobAccessTierHelper(options.getBlobIdentifier(), options.getTier(), options.getPriority(), options.getLeaseId(), options.getTagsConditions());
    }

    private Response<Void> setBlobAccessTierHelper(String blobPath, AccessTier tier, RehydratePriority priority, String leaseId, String tagsConditions) {
        this.setBatchType(BlobBatchType.SET_TIER);
        return this.createBatchOperation(this.blobAsyncClient.setAccessTierWithResponse(new BlobSetAccessTierOptions(tier).setLeaseId(leaseId).setPriority(priority).setTagsConditions(tagsConditions)), blobPath, EXPECTED_SET_TIER_STATUS_CODES);
    }

    private <T> Response<T> createBatchOperation(Mono<Response<T>> response, String urlPath, int ... expectedStatusCodes) {
        BlobBatchOperationResponse batchOperationResponse = new BlobBatchOperationResponse(expectedStatusCodes);
        this.batchOperationQueue.add(new BlobBatchOperation(batchOperationResponse, response, urlPath));
        return batchOperationResponse;
    }

    private String getUrlPath(String url) {
        return UrlBuilder.parse((String)url).getPath();
    }

    private void setBatchType(BlobBatchType batchType) {
        if (this.batchType == null) {
            this.batchType = batchType;
        } else if (this.batchType != batchType) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format(Locale.ROOT, "'BlobBatch' only supports homogeneous operations and is a %s batch.", new Object[]{this.batchType})));
        }
    }

    Mono<BlobBatchOperationInfo> prepareBlobBatchSubmission() {
        if (this.batchOperationQueue.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new UnsupportedOperationException("Empty batch requests aren't allowed."));
        }
        BlobBatchOperationInfo operationInfo = new BlobBatchOperationInfo();
        Deque<BlobBatchOperation<?>> operations = this.batchOperationQueue;
        this.batchOperationQueue = new ConcurrentLinkedDeque();
        ArrayList<Mono> batchOperationResponses = new ArrayList<Mono>();
        while (!operations.isEmpty()) {
            BlobBatchOperation<?> batchOperation = operations.pop();
            batchOperationResponses.add(batchOperation.getResponse().subscriberContext(Context.of((Object)BATCH_REQUEST_URL_PATH, (Object)batchOperation.getRequestUrlPath(), (Object)BATCH_OPERATION_RESPONSE, batchOperation.getBatchOperationResponse(), (Object)BATCH_OPERATION_INFO, (Object)operationInfo)));
        }
        return Mono.when(batchOperationResponses).doOnSuccess(ignored -> operationInfo.finalizeBatchOperations()).thenReturn((Object)operationInfo);
    }

    private Mono<HttpResponse> cleanseHeaders(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        context.getHttpRequest().getHeaders().remove(X_MS_VERSION);
        for (HttpHeader hdr : context.getHttpRequest().getHeaders()) {
            if (hdr.getValue() != null) continue;
            context.getHttpRequest().getHeaders().remove(hdr.getName());
        }
        return next.process();
    }

    private Mono<HttpResponse> setRequestUrl(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        try {
            UrlBuilder requestUrl = UrlBuilder.parse((URL)context.getHttpRequest().getUrl());
            requestUrl.setPath(context.getData(BATCH_REQUEST_URL_PATH).get().toString());
            context.getHttpRequest().setUrl(requestUrl.toUrl());
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new IllegalStateException(ex)));
        }
        return next.process();
    }

    private Mono<HttpResponse> buildBatchOperation(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        BlobBatchOperationInfo operationInfo = (BlobBatchOperationInfo)context.getData(BATCH_OPERATION_INFO).get();
        BlobBatchOperationResponse batchOperationResponse = (BlobBatchOperationResponse)context.getData(BATCH_OPERATION_RESPONSE).get();
        operationInfo.addBatchOperation(batchOperationResponse, context.getHttpRequest());
        return Mono.empty();
    }
}

