/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class AtopConnectorConfig {
    private String executablePath = "atop";
    private String timeZone = ZoneId.systemDefault().getId();
    private AtopSecurity security = AtopSecurity.ALLOW_ALL;
    private Duration readTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int concurrentReadersPerNode = 1;
    private int maxHistoryDays = 30;

    @NotNull
    public AtopSecurity getSecurity() {
        return this.security;
    }

    @Config(value="atop.security")
    public AtopConnectorConfig setSecurity(AtopSecurity security) {
        this.security = security;
        return this;
    }

    @NotNull
    @FileExists
    public String getExecutablePath() {
        return this.executablePath;
    }

    @Config(value="atop.executable-path")
    public AtopConnectorConfig setExecutablePath(String path) {
        this.executablePath = path;
        return this;
    }

    public ZoneId getTimeZoneId() {
        return ZoneId.of(this.timeZone);
    }

    @NotNull
    public String getTimeZone() {
        return this.timeZone;
    }

    @Config(value="atop.time-zone")
    @ConfigDescription(value="The timezone in which the atop data was collected. Generally the timezone of the host.")
    public AtopConnectorConfig setTimeZone(String id) {
        this.timeZone = id;
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Config(value="atop.executable-read-timeout")
    @ConfigDescription(value="The timeout when reading from the atop process.")
    public AtopConnectorConfig setReadTimeout(Duration timeout) {
        this.readTimeout = timeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConcurrentReadersPerNode() {
        return this.concurrentReadersPerNode;
    }

    @Config(value="atop.concurrent-readers-per-node")
    public AtopConnectorConfig setConcurrentReadersPerNode(int readers) {
        this.concurrentReadersPerNode = readers;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxHistoryDays() {
        return this.maxHistoryDays;
    }

    @Config(value="atop.max-history-days")
    public AtopConnectorConfig setMaxHistoryDays(int maxHistoryDays) {
        this.maxHistoryDays = maxHistoryDays;
        return this;
    }

    public static enum AtopSecurity {
        ALLOW_ALL,
        FILE;

    }
}

