/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.google.common.collect.ImmutableSet;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.elasticsearch.ElasticsearchMetadata;
import io.trino.plugin.elasticsearch.ElasticsearchPageSourceProvider;
import io.trino.plugin.elasticsearch.ElasticsearchSplitManager;
import io.trino.plugin.elasticsearch.ElasticsearchTransactionHandle;
import io.trino.plugin.elasticsearch.NodesSystemTable;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class ElasticsearchConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final ElasticsearchMetadata metadata;
    private final ElasticsearchSplitManager splitManager;
    private final ElasticsearchPageSourceProvider pageSourceProvider;
    private final NodesSystemTable nodesSystemTable;
    private final Set<ConnectorTableFunction> connectorTableFunctions;

    @Inject
    public ElasticsearchConnector(LifeCycleManager lifeCycleManager, ElasticsearchMetadata metadata, ElasticsearchSplitManager splitManager, ElasticsearchPageSourceProvider pageSourceProvider, NodesSystemTable nodesSystemTable, Set<ConnectorTableFunction> connectorTableFunctions) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.nodesSystemTable = Objects.requireNonNull(nodesSystemTable, "nodesSystemTable is null");
        this.connectorTableFunctions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(connectorTableFunctions, "connectorTableFunctions is null"));
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return ElasticsearchTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public Set<SystemTable> getSystemTables() {
        return ImmutableSet.of((Object)this.nodesSystemTable);
    }

    public Set<ConnectorTableFunction> getTableFunctions() {
        return this.connectorTableFunctions;
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }
}

