/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.trino.filesystem.FileIterator;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HadoopPaths;
import io.trino.filesystem.hdfs.HdfsFileIterator;
import io.trino.filesystem.hdfs.HdfsInputFile;
import io.trino.filesystem.hdfs.HdfsOutputFile;
import io.trino.hdfs.FileSystemUtils;
import io.trino.hdfs.FileSystemWithBatchDelete;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

class HdfsFileSystem
implements TrinoFileSystem {
    private final HdfsEnvironment environment;
    private final HdfsContext context;

    public HdfsFileSystem(HdfsEnvironment environment, HdfsContext context) {
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
    }

    public TrinoInputFile newInputFile(String location) {
        return new HdfsInputFile(location, null, this.environment, this.context);
    }

    public TrinoInputFile newInputFile(String location, long length) {
        return new HdfsInputFile(location, length, this.environment, this.context);
    }

    public TrinoOutputFile newOutputFile(String location) {
        return new HdfsOutputFile(location, this.environment, this.context);
    }

    public void deleteFile(String location) throws IOException {
        Path file = HadoopPaths.hadoopPath(location);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, file);
        this.environment.doAs(this.context.getIdentity(), () -> {
            if (!fileSystem.delete(file, false)) {
                throw new IOException("Failed to delete file: " + file);
            }
            return null;
        });
    }

    public void deleteFiles(Collection<String> locations) throws IOException {
        Map pathsGroupedByDirectory = locations.stream().collect(Collectors.groupingBy(path -> HadoopPaths.hadoopPath(path.replaceFirst("/[^/]*$", "")), Collectors.mapping(HadoopPaths::hadoopPath, Collectors.toList())));
        for (Map.Entry directoryWithPaths : pathsGroupedByDirectory.entrySet()) {
            FileSystem rawFileSystem = FileSystemUtils.getRawFileSystem(this.environment.getFileSystem(this.context, directoryWithPaths.getKey()));
            this.environment.doAs(this.context.getIdentity(), () -> {
                if (rawFileSystem instanceof FileSystemWithBatchDelete) {
                    FileSystemWithBatchDelete fileSystemWithBatchDelete = (FileSystemWithBatchDelete)rawFileSystem;
                    fileSystemWithBatchDelete.deleteFiles((Collection)directoryWithPaths.getValue());
                } else {
                    for (Path path : (List)directoryWithPaths.getValue()) {
                        rawFileSystem.delete(path, false);
                    }
                }
                return null;
            });
        }
    }

    public void deleteDirectory(String location) throws IOException {
        Path directory = HadoopPaths.hadoopPath(location);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, directory);
        this.environment.doAs(this.context.getIdentity(), () -> {
            if (!fileSystem.delete(directory, true) && fileSystem.exists(directory)) {
                throw new IOException("Failed to delete directory: " + directory);
            }
            return null;
        });
    }

    public void renameFile(String source, String target) throws IOException {
        Path sourcePath = HadoopPaths.hadoopPath(source);
        Path targetPath = HadoopPaths.hadoopPath(target);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, sourcePath);
        this.environment.doAs(this.context.getIdentity(), () -> {
            if (!fileSystem.rename(sourcePath, targetPath)) {
                throw new IOException(String.format("Failed to rename [%s] to [%s]", source, target));
            }
            return null;
        });
    }

    public FileIterator listFiles(String location) throws IOException {
        Path directory = HadoopPaths.hadoopPath(location);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, directory);
        return this.environment.doAs(this.context.getIdentity(), () -> {
            try {
                return new HdfsFileIterator(location, fileSystem, (RemoteIterator<LocatedFileStatus>)fileSystem.listFiles(directory, true));
            }
            catch (FileNotFoundException e) {
                return FileIterator.empty();
            }
        });
    }
}

