/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HadoopPaths;
import io.trino.hdfs.FileSystemUtils;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.MemoryAwareFileSystem;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class HdfsOutputFile
implements TrinoOutputFile {
    private final String path;
    private final HdfsEnvironment environment;
    private final HdfsContext context;

    public HdfsOutputFile(String path, HdfsEnvironment environment, HdfsContext context) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
    }

    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        return this.create(false, memoryContext);
    }

    public OutputStream createOrOverwrite(AggregatedMemoryContext memoryContext) throws IOException {
        return this.create(true, memoryContext);
    }

    private OutputStream create(boolean overwrite, AggregatedMemoryContext memoryContext) throws IOException {
        Path file = HadoopPaths.hadoopPath(this.path);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, file);
        FileSystem rawFileSystem = FileSystemUtils.getRawFileSystem(fileSystem);
        if (rawFileSystem instanceof MemoryAwareFileSystem) {
            MemoryAwareFileSystem memoryAwareFileSystem = (MemoryAwareFileSystem)rawFileSystem;
            return this.environment.doAs(this.context.getIdentity(), () -> memoryAwareFileSystem.create(file, memoryContext));
        }
        return (OutputStream)this.environment.doAs(this.context.getIdentity(), () -> fileSystem.create(file, overwrite));
    }

    public String location() {
        return this.path;
    }

    public String toString() {
        return this.location();
    }
}

