/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.trino.parquet.DataPage;
import io.trino.parquet.ParquetEncoding;
import java.util.Objects;
import java.util.OptionalLong;

public final class DataPageV1
extends DataPage {
    private final Slice slice;
    private final ParquetEncoding repetitionLevelEncoding;
    private final ParquetEncoding definitionLevelEncoding;
    private final ParquetEncoding valuesEncoding;

    public DataPageV1(Slice slice, int valueCount, int uncompressedSize, OptionalLong firstRowIndex, ParquetEncoding repetitionLevelEncoding, ParquetEncoding definitionLevelEncoding, ParquetEncoding valuesEncoding) {
        super(uncompressedSize, valueCount, firstRowIndex);
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.repetitionLevelEncoding = repetitionLevelEncoding;
        this.definitionLevelEncoding = definitionLevelEncoding;
        this.valuesEncoding = valuesEncoding;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public ParquetEncoding getDefinitionLevelEncoding() {
        return this.definitionLevelEncoding;
    }

    public ParquetEncoding getRepetitionLevelEncoding() {
        return this.repetitionLevelEncoding;
    }

    public ParquetEncoding getValueEncoding() {
        return this.valuesEncoding;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("slice", (Object)this.slice).add("repetitionLevelEncoding", (Object)this.repetitionLevelEncoding).add("definitionLevelEncoding", (Object)this.definitionLevelEncoding).add("valuesEncoding", (Object)this.valuesEncoding).add("valueCount", this.valueCount).add("uncompressedSize", this.uncompressedSize).toString();
    }
}

