/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.Preconditions;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ValuesType;
import io.trino.parquet.dictionary.BinaryDictionary;
import io.trino.parquet.dictionary.Dictionary;
import io.trino.parquet.dictionary.DictionaryReader;
import io.trino.parquet.dictionary.DoubleDictionary;
import io.trino.parquet.dictionary.FloatDictionary;
import io.trino.parquet.dictionary.IntegerDictionary;
import io.trino.parquet.dictionary.LongDictionary;
import java.io.IOException;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayReader;
import org.apache.parquet.column.values.plain.BinaryPlainValuesReader;
import org.apache.parquet.column.values.plain.BooleanPlainValuesReader;
import org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesReader;
import org.apache.parquet.column.values.plain.PlainValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesReader;
import org.apache.parquet.column.values.rle.ZeroIntegerValuesReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.PrimitiveType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ParquetEncoding {
    PLAIN{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            return switch (descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                default -> throw new IncompatibleClassChangeError();
                case PrimitiveType.PrimitiveTypeName.BOOLEAN -> new BooleanPlainValuesReader();
                case PrimitiveType.PrimitiveTypeName.BINARY -> new BinaryPlainValuesReader();
                case PrimitiveType.PrimitiveTypeName.FLOAT -> new PlainValuesReader.FloatPlainValuesReader();
                case PrimitiveType.PrimitiveTypeName.DOUBLE -> new PlainValuesReader.DoublePlainValuesReader();
                case PrimitiveType.PrimitiveTypeName.INT32 -> new PlainValuesReader.IntegerPlainValuesReader();
                case PrimitiveType.PrimitiveTypeName.INT64 -> new PlainValuesReader.LongPlainValuesReader();
                case PrimitiveType.PrimitiveTypeName.INT96 -> new FixedLenByteArrayPlainValuesReader(12);
                case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> new FixedLenByteArrayPlainValuesReader(descriptor.getPrimitiveType().getTypeLength());
            };
        }

        @Override
        public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
            return switch (descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                default -> throw new IncompatibleClassChangeError();
                case PrimitiveType.PrimitiveTypeName.BOOLEAN -> throw new ParquetDecodingException("Dictionary encoding does not support: " + descriptor.getPrimitiveType().getPrimitiveTypeName());
                case PrimitiveType.PrimitiveTypeName.BINARY -> new BinaryDictionary(dictionaryPage);
                case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> new BinaryDictionary(dictionaryPage, descriptor.getPrimitiveType().getTypeLength());
                case PrimitiveType.PrimitiveTypeName.INT96 -> new BinaryDictionary(dictionaryPage, 12);
                case PrimitiveType.PrimitiveTypeName.INT64 -> new LongDictionary(dictionaryPage);
                case PrimitiveType.PrimitiveTypeName.DOUBLE -> new DoubleDictionary(dictionaryPage);
                case PrimitiveType.PrimitiveTypeName.INT32 -> new IntegerDictionary(dictionaryPage);
                case PrimitiveType.PrimitiveTypeName.FLOAT -> new FloatDictionary(dictionaryPage);
            };
        }
    }
    ,
    RLE{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            int bitWidth = BytesUtils.getWidthFromMaxInt((int)2.getMaxLevel(descriptor, valuesType));
            if (bitWidth == 0) {
                return new ZeroIntegerValuesReader();
            }
            return new RunLengthBitPackingHybridValuesReader(bitWidth);
        }
    }
    ,
    BIT_PACKED{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            return new ByteBitPackingValuesReader(3.getMaxLevel(descriptor, valuesType), Packer.BIG_ENDIAN);
        }
    }
    ,
    PLAIN_DICTIONARY{

        @Override
        public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
            return RLE_DICTIONARY.getDictionaryBasedValuesReader(descriptor, valuesType, dictionary);
        }

        @Override
        public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
            return PLAIN.initDictionary(descriptor, dictionaryPage);
        }

        @Override
        public boolean usesDictionary() {
            return true;
        }
    }
    ,
    DELTA_BINARY_PACKED{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            PrimitiveType.PrimitiveTypeName typeName = descriptor.getPrimitiveType().getPrimitiveTypeName();
            Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.INT32 || typeName == PrimitiveType.PrimitiveTypeName.INT64 ? 1 : 0) != 0, (Object)"Encoding DELTA_BINARY_PACKED is only supported for type INT32 and INT64");
            return new DeltaBinaryPackingValuesReader();
        }
    }
    ,
    DELTA_LENGTH_BYTE_ARRAY{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            Preconditions.checkArgument((descriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY ? 1 : 0) != 0, (Object)"Encoding DELTA_LENGTH_BYTE_ARRAY is only supported for type BINARY");
            return new DeltaLengthByteArrayValuesReader();
        }
    }
    ,
    DELTA_BYTE_ARRAY{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            PrimitiveType.PrimitiveTypeName typeName = descriptor.getPrimitiveType().getPrimitiveTypeName();
            Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.BINARY || typeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? 1 : 0) != 0, (Object)"Encoding DELTA_BYTE_ARRAY is only supported for type BINARY and FIXED_LEN_BYTE_ARRAY");
            return new DeltaByteArrayReader();
        }
    }
    ,
    RLE_DICTIONARY{

        @Override
        public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
            return new DictionaryReader(dictionary);
        }

        @Override
        public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
            return PLAIN.initDictionary(descriptor, dictionaryPage);
        }

        @Override
        public boolean usesDictionary() {
            return true;
        }
    };

    static final int INT96_TYPE_LENGTH = 12;

    static int getMaxLevel(ColumnDescriptor descriptor, ValuesType valuesType) {
        return switch (valuesType) {
            default -> throw new IncompatibleClassChangeError();
            case ValuesType.REPETITION_LEVEL -> descriptor.getMaxRepetitionLevel();
            case ValuesType.DEFINITION_LEVEL -> descriptor.getMaxDefinitionLevel();
            case ValuesType.VALUES -> {
                if (descriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BOOLEAN) {
                    yield 1;
                }
                throw new ParquetDecodingException("Unsupported values type: " + valuesType);
            }
        };
    }

    public boolean usesDictionary() {
        return false;
    }

    public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
        throw new UnsupportedOperationException(" Dictionary encoding is not supported for: " + this.name());
    }

    public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
        throw new UnsupportedOperationException("Error decoding  values in encoding: " + this.name());
    }

    public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
        throw new UnsupportedOperationException(" Dictionary encoding is not supported for: " + this.name());
    }
}

