/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.trino.parquet.DataPage;
import io.trino.parquet.DataPageV1;
import io.trino.parquet.DataPageV2;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.ValuesType;
import io.trino.parquet.dictionary.Dictionary;
import io.trino.parquet.reader.ColumnChunk;
import io.trino.parquet.reader.ColumnReader;
import io.trino.parquet.reader.FilteredRowRanges;
import io.trino.parquet.reader.LevelNullReader;
import io.trino.parquet.reader.LevelRLEReader;
import io.trino.parquet.reader.LevelReader;
import io.trino.parquet.reader.LevelValuesReader;
import io.trino.parquet.reader.PageReader;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import javax.annotation.Nullable;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.io.ParquetDecodingException;

public abstract class PrimitiveColumnReader
implements ColumnReader {
    private static final int EMPTY_LEVEL_VALUE = -1;
    protected final PrimitiveField field;
    protected int definitionLevel = -1;
    protected int repetitionLevel = -1;
    protected ValuesReader valuesReader;
    private int nextBatchSize;
    private LevelReader repetitionReader;
    private LevelReader definitionReader;
    private PageReader pageReader;
    private Dictionary dictionary;
    private DataPage page;
    private int remainingValueCountInPage;
    private int readOffset;
    @Nullable
    private PrimitiveIterator.OfLong indexIterator;
    private long currentRow;
    private long targetRow;

    protected abstract void readValue(BlockBuilder var1, Type var2);

    private void skipSingleValue() {
        if (this.definitionLevel == this.field.getDescriptor().getMaxDefinitionLevel()) {
            this.valuesReader.skip();
        }
    }

    protected boolean isValueNull() {
        return ParquetTypeUtils.isValueNull(this.field.isRequired(), this.definitionLevel, this.field.getDefinitionLevel());
    }

    public PrimitiveColumnReader(PrimitiveField field) {
        this.field = Objects.requireNonNull(field, "columnDescriptor");
        this.pageReader = null;
        this.targetRow = 0L;
        this.indexIterator = null;
    }

    @Override
    public boolean hasPageReader() {
        return this.pageReader != null;
    }

    @Override
    public void setPageReader(PageReader pageReader, Optional<FilteredRowRanges> rowRanges) {
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader");
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(this.field.getDescriptor(), dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + this.field.getDescriptor(), (Throwable)e);
            }
        } else {
            this.dictionary = null;
        }
        if (rowRanges.isPresent()) {
            this.indexIterator = rowRanges.get().getParquetRowRanges().iterator();
            Preconditions.checkArgument((boolean)this.indexIterator.hasNext(), (Object)"rowRanges is empty");
            this.targetRow = this.indexIterator.next();
        }
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public ColumnChunk readPrimitive() {
        int valuesToRead;
        IntArrayList definitionLevels = new IntArrayList(this.nextBatchSize);
        IntArrayList repetitionLevels = new IntArrayList(this.nextBatchSize);
        this.seek();
        BlockBuilder blockBuilder = this.field.getType().createBlockBuilder(null, this.nextBatchSize);
        for (int valueCount = 0; valueCount < this.nextBatchSize; valueCount += valuesToRead) {
            if (this.page == null) {
                this.readNextPage();
            }
            if ((valuesToRead = Math.min(this.remainingValueCountInPage, this.nextBatchSize - valueCount)) == 0) break;
            this.readValues(blockBuilder, valuesToRead, this.field.getType(), (IntList)definitionLevels, (IntList)repetitionLevels);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return new ColumnChunk(blockBuilder.build(), definitionLevels.toIntArray(), repetitionLevels.toIntArray());
    }

    private void readValues(BlockBuilder blockBuilder, int valuesToRead, Type type, IntList definitionLevels, IntList repetitionLevels) {
        this.processValues(valuesToRead, () -> {
            if (this.definitionLevel == this.field.getDefinitionLevel()) {
                this.readValue(blockBuilder, type);
            } else if (this.isValueNull()) {
                blockBuilder.appendNull();
            }
            definitionLevels.add(this.definitionLevel);
            repetitionLevels.add(this.repetitionLevel);
        });
    }

    private void skipValues(long valuesToRead) {
        this.processValues(valuesToRead, this::skipSingleValue);
    }

    private void processValues(long valuesToRead, Runnable valueReader) {
        if (this.definitionLevel == -1 && this.repetitionLevel == -1) {
            this.definitionLevel = this.definitionReader.readLevel();
            this.repetitionLevel = this.repetitionReader.readLevel();
        }
        int valueCount = 0;
        int skipCount = 0;
        int i = 0;
        while ((long)i < valuesToRead) {
            boolean consumed;
            do {
                if (this.incrementRowAndTestIfTargetReached(this.repetitionLevel)) {
                    valueReader.run();
                    ++valueCount;
                    consumed = true;
                } else {
                    this.skipSingleValue();
                    ++skipCount;
                    consumed = false;
                }
                if (valueCount + skipCount == this.remainingValueCountInPage) {
                    this.updateValueCounts(valueCount, skipCount);
                    if (!this.readNextPage()) {
                        return;
                    }
                    valueCount = 0;
                    skipCount = 0;
                }
                this.repetitionLevel = this.repetitionReader.readLevel();
                this.definitionLevel = this.definitionReader.readLevel();
            } while (this.repetitionLevel != 0);
            if (!consumed) continue;
            ++i;
        }
        this.updateValueCounts(valueCount, skipCount);
    }

    private void seek() {
        int valuePosition;
        int offset;
        if (this.readOffset == 0) {
            return;
        }
        int readOffset = this.readOffset;
        for (valuePosition = 0; valuePosition < readOffset && (this.page != null || this.readNextPage()); valuePosition += offset) {
            offset = Math.min(this.remainingValueCountInPage, readOffset - valuePosition);
            this.skipValues(offset);
        }
        Preconditions.checkArgument((valuePosition == readOffset ? 1 : 0) != 0, (String)"valuePosition %s must be equal to readOffset %s", (int)valuePosition, (int)readOffset);
    }

    private boolean readNextPage() {
        Verify.verify((this.page == null ? 1 : 0) != 0, (String)"readNextPage has to be called when page is null", (Object[])new Object[0]);
        this.page = this.pageReader.readPage();
        if (this.page == null) {
            return false;
        }
        this.remainingValueCountInPage = this.page.getValueCount();
        this.valuesReader = this.page instanceof DataPageV1 ? this.readPageV1((DataPageV1)this.page) : this.readPageV2((DataPageV2)this.page);
        return true;
    }

    private void updateValueCounts(int valuesRead, int skipCount) {
        int totalCount = valuesRead + skipCount;
        if (totalCount == this.remainingValueCountInPage) {
            this.page = null;
            this.valuesReader = null;
        }
        this.remainingValueCountInPage -= totalCount;
    }

    private ValuesReader readPageV1(DataPageV1 page) {
        ValuesReader rlReader = page.getRepetitionLevelEncoding().getValuesReader(this.field.getDescriptor(), ValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDefinitionLevelEncoding().getValuesReader(this.field.getDescriptor(), ValuesType.DEFINITION_LEVEL);
        this.repetitionReader = new LevelValuesReader(rlReader);
        this.definitionReader = new LevelValuesReader(dlReader);
        try {
            ByteBufferInputStream in = ParquetReaderUtils.toInputStream(page.getSlice());
            rlReader.initFromPage(page.getValueCount(), in);
            dlReader.initFromPage(page.getValueCount(), in);
            return this.initDataReader(page.getValueEncoding(), page.getValueCount(), in, page.getFirstRowIndex());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page " + page + " in column " + this.field.getDescriptor(), (Throwable)e);
        }
    }

    private ValuesReader readPageV2(DataPageV2 page) {
        this.repetitionReader = this.buildLevelRLEReader(this.field.getDescriptor().getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionReader = this.buildLevelRLEReader(this.field.getDescriptor().getMaxDefinitionLevel(), page.getDefinitionLevels());
        return this.initDataReader(page.getDataEncoding(), page.getValueCount(), ParquetReaderUtils.toInputStream(page.getSlice()), page.getFirstRowIndex());
    }

    private LevelReader buildLevelRLEReader(int maxLevel, Slice slice) {
        if (maxLevel == 0) {
            return new LevelNullReader();
        }
        return new LevelRLEReader(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), (InputStream)slice.getInput()));
    }

    private ValuesReader initDataReader(ParquetEncoding dataEncoding, int valueCount, ByteBufferInputStream in, OptionalLong firstRowIndex) {
        ValuesReader valuesReader;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("Dictionary is missing for Page");
            }
            valuesReader = dataEncoding.getDictionaryBasedValuesReader(this.field.getDescriptor(), ValuesType.VALUES, this.dictionary);
        } else {
            valuesReader = dataEncoding.getValuesReader(this.field.getDescriptor(), ValuesType.VALUES);
        }
        try {
            valuesReader.initFromPage(valueCount, in);
            if (firstRowIndex.isPresent()) {
                this.currentRow = firstRowIndex.getAsLong();
            }
            return valuesReader;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page in column " + this.field.getDescriptor(), (Throwable)e);
        }
    }

    private boolean incrementRowAndTestIfTargetReached(int repetitionLevel) {
        if (this.indexIterator == null) {
            return true;
        }
        if (repetitionLevel == 0) {
            if (this.currentRow > this.targetRow) {
                this.targetRow = this.indexIterator.hasNext() ? this.indexIterator.next() : Long.MAX_VALUE;
            }
            boolean isAtTargetRow = this.currentRow == this.targetRow;
            ++this.currentRow;
            return isAtTargetRow;
        }
        return this.currentRow - 1L == this.targetRow;
    }
}

