/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.base.Preconditions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Type;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class FixedLenByteArrayLongDecimalValueWriter
extends PrimitiveValueWriter {
    private final DecimalType decimalType;

    public FixedLenByteArrayLongDecimalValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.decimalType = (DecimalType)Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((!this.decimalType.isShort() ? 1 : 0) != 0, (Object)"type is not a long decimal");
        Preconditions.checkArgument((parquetType.getTypeLength() > 0 && parquetType.getTypeLength() <= 16 ? 1 : 0) != 0, (String)"Type length %s must be in range 1-%s", (int)parquetType.getTypeLength(), (int)16);
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            Int128 decimal = (Int128)this.decimalType.getObject(block, i);
            BigInteger bigInteger = decimal.toBigInteger();
            Binary binary = Binary.fromConstantByteArray((byte[])ParquetTypeUtils.paddingBigInteger(bigInteger, this.getTypeLength()));
            this.getValueWriter().writeBytes(binary);
            this.getStatistics().updateStats(binary);
        }
    }
}

