/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.cost;

import io.trino.hive.$internal.com.google.common.collect.ImmutableList;
import io.trino.hive.$internal.com.google.common.collect.Sets;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;

public class HiveDefaultCostModel
extends HiveCostModel {
    private static HiveDefaultCostModel INSTANCE;

    public static synchronized HiveDefaultCostModel getCostModel() {
        if (INSTANCE == null) {
            INSTANCE = new HiveDefaultCostModel();
        }
        return INSTANCE;
    }

    private HiveDefaultCostModel() {
        super(Sets.newHashSet(DefaultJoinAlgorithm.INSTANCE));
    }

    @Override
    public RelOptCost getDefaultCost() {
        return HiveCost.FACTORY.makeZeroCost();
    }

    @Override
    public RelOptCost getScanCost(HiveTableScan ts, RelMetadataQuery mq) {
        return HiveCost.FACTORY.makeZeroCost();
    }

    @Override
    public RelOptCost getAggregateCost(HiveAggregate aggregate) {
        return HiveCost.FACTORY.makeZeroCost();
    }

    public static class DefaultJoinAlgorithm
    implements HiveCostModel.JoinAlgorithm {
        public static final HiveCostModel.JoinAlgorithm INSTANCE = new DefaultJoinAlgorithm();
        private static final String ALGORITHM_NAME = "none";

        @Override
        public String toString() {
            return ALGORITHM_NAME;
        }

        @Override
        public boolean isExecutable(HiveJoin join) {
            return true;
        }

        @Override
        public RelOptCost getCost(HiveJoin join) {
            RelMetadataQuery mq = join.getCluster().getMetadataQuery();
            double leftRCount = mq.getRowCount(join.getLeft());
            double rightRCount = mq.getRowCount(join.getRight());
            return HiveCost.FACTORY.makeCost(leftRCount + rightRCount, 0.0, 0.0);
        }

        @Override
        public ImmutableList<RelCollation> getCollation(HiveJoin join) {
            return ImmutableList.of();
        }

        @Override
        public RelDistribution getDistribution(HiveJoin join) {
            return RelDistributions.SINGLETON;
        }

        @Override
        public Double getMemory(HiveJoin join) {
            return null;
        }

        @Override
        public Double getCumulativeMemoryWithinPhaseSplit(HiveJoin join) {
            return null;
        }

        @Override
        public Boolean isPhaseTransition(HiveJoin join) {
            return false;
        }

        @Override
        public Integer getSplitCount(HiveJoin join) {
            return 1;
        }
    }
}

