/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.ReadType;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.OpenFilePOptions;
import alluxio.master.block.BlockId;
import alluxio.master.file.meta.PersistenceState;
import alluxio.proto.dataserver.Protocol;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.FileSystemOptions;
import alluxio.wire.BlockInfo;
import alluxio.wire.FileBlockInfo;

@NotThreadSafe
public final class InStreamOptions {
    private final URIStatus mStatus;
    private final OpenFilePOptions mProtoOptions;
    private BlockLocationPolicy mUfsReadLocationPolicy;
    private boolean mPositionShort;

    public InStreamOptions(URIStatus status, AlluxioConfiguration alluxioConf) {
        this(status, FileSystemOptions.openFileDefaults(alluxioConf), alluxioConf);
    }

    public InStreamOptions(URIStatus status, OpenFilePOptions options, AlluxioConfiguration alluxioConf) {
        OpenFilePOptions.Builder openOptionsBuilder = OpenFilePOptions.newBuilder().setReadType(alluxioConf.getEnum(PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.class).toProto()).setMaxUfsReadConcurrency(alluxioConf.getInt(PropertyKey.USER_UFS_BLOCK_READ_CONCURRENCY_MAX));
        OpenFilePOptions openOptions = openOptionsBuilder.mergeFrom(options).build();
        this.mStatus = status;
        this.mProtoOptions = openOptions;
        this.mUfsReadLocationPolicy = BlockLocationPolicy.Factory.create(alluxioConf.getClass(PropertyKey.USER_UFS_BLOCK_READ_LOCATION_POLICY), alluxioConf);
        this.mPositionShort = false;
    }

    public OpenFilePOptions getOptions() {
        return this.mProtoOptions;
    }

    @VisibleForTesting
    public void setUfsReadLocationPolicy(BlockLocationPolicy ufsReadLocationPolicy) {
        this.mUfsReadLocationPolicy = Preconditions.checkNotNull(ufsReadLocationPolicy);
    }

    public void setPositionShort(boolean positionShort) {
        this.mPositionShort = positionShort;
    }

    public BlockLocationPolicy getUfsReadLocationPolicy() {
        return this.mUfsReadLocationPolicy;
    }

    public URIStatus getStatus() {
        return this.mStatus;
    }

    public boolean getPositionShort() {
        return this.mPositionShort;
    }

    public BlockInfo getBlockInfo(long blockId) {
        Preconditions.checkArgument(this.mStatus.getBlockIds().contains(blockId), "blockId");
        return this.mStatus.getFileBlockInfos().stream().map(FileBlockInfo::getBlockInfo).filter(blockInfo -> blockInfo.getBlockId() == blockId).findFirst().get();
    }

    public Protocol.OpenUfsBlockOptions getOpenUfsBlockOptions(long blockId) {
        Preconditions.checkArgument(this.mStatus.getBlockIds().contains(blockId), "block id %s does not belong to the file %s", blockId, (Object)this.mStatus.getPath());
        boolean storedAsUfsBlock = this.mStatus.getPersistenceState().equals(PersistenceState.TO_BE_PERSISTED.name());
        if (!this.mStatus.isPersisted() && !storedAsUfsBlock) {
            return Protocol.OpenUfsBlockOptions.getDefaultInstance();
        }
        long blockStart = BlockId.getSequenceNumber(blockId) * this.mStatus.getBlockSizeBytes();
        BlockInfo info = this.getBlockInfo(blockId);
        Protocol.OpenUfsBlockOptions.Builder openUfsBlockOptionsBuilder = Protocol.OpenUfsBlockOptions.newBuilder().setUfsPath(this.mStatus.getUfsPath()).setOffsetInFile(blockStart).setBlockSize(info.getLength()).setMaxUfsReadConcurrency(this.mProtoOptions.getMaxUfsReadConcurrency()).setNoCache(!ReadType.fromProto(this.mProtoOptions.getReadType()).isCache()).setMountId(this.mStatus.getMountId());
        if (storedAsUfsBlock) {
            openUfsBlockOptionsBuilder.clearUfsPath().setBlockInUfsTier(true).setOffsetInFile(0L);
        }
        return openUfsBlockOptionsBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InStreamOptions)) {
            return false;
        }
        InStreamOptions that = (InStreamOptions)o;
        return Objects.equal(this.mStatus, that.mStatus) && Objects.equal(this.mProtoOptions, that.mProtoOptions) && Objects.equal(this.mPositionShort, that.mPositionShort);
    }

    public int hashCode() {
        return Objects.hashCode(this.mStatus, this.mProtoOptions, this.mPositionShort);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("URIStatus", this.mStatus).add("OpenFileOptions", this.mProtoOptions).add("PositionShort", this.mPositionShort).toString();
    }
}

