/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.worker.block.BlockStoreLocation;

public class AllocateOptions {
    private long mSize;
    private BlockStoreLocation mLocation;
    private boolean mForceLocation;
    private boolean mEvictionAllowed;
    private boolean mUseReservedSpace;

    private AllocateOptions(BlockStoreLocation location, long size) {
        this.mLocation = location;
        this.mSize = size;
    }

    private AllocateOptions(BlockStoreLocation location) {
        this(location, 0L);
    }

    public static AllocateOptions forCreate(long sizeBytes, BlockStoreLocation location) {
        return new AllocateOptions(location, sizeBytes).setForceLocation(false).setEvictionAllowed(true);
    }

    public static AllocateOptions forRequestSpace(long sizeBytes, BlockStoreLocation location) {
        return new AllocateOptions(location, sizeBytes).setForceLocation(true).setEvictionAllowed(true);
    }

    public static AllocateOptions forTierMove(BlockStoreLocation location) {
        return new AllocateOptions(location).setForceLocation(true).setEvictionAllowed(false);
    }

    public static AllocateOptions forMove(BlockStoreLocation location) {
        return new AllocateOptions(location).setForceLocation(true).setEvictionAllowed(true);
    }

    public AllocateOptions setLocation(BlockStoreLocation location) {
        this.mLocation = location;
        return this;
    }

    public AllocateOptions setSize(long size) {
        this.mSize = size;
        return this;
    }

    public AllocateOptions setForceLocation(boolean forceLocation) {
        this.mForceLocation = forceLocation;
        return this;
    }

    public AllocateOptions setEvictionAllowed(boolean evictionAllowed) {
        this.mEvictionAllowed = evictionAllowed;
        return this;
    }

    public AllocateOptions setUseReservedSpace(boolean useReservedSpace) {
        this.mUseReservedSpace = useReservedSpace;
        return this;
    }

    public BlockStoreLocation getLocation() {
        return this.mLocation;
    }

    public long getSize() {
        return this.mSize;
    }

    public boolean isForceLocation() {
        return this.mForceLocation;
    }

    public boolean isEvictionAllowed() {
        return this.mEvictionAllowed;
    }

    public boolean canUseReservedSpace() {
        return this.mUseReservedSpace;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AllocateOptions)) {
            return false;
        }
        AllocateOptions other = (AllocateOptions)o;
        return this.mSize == other.mSize && this.mLocation.equals(other.mLocation) && this.mForceLocation == other.mForceLocation && this.mEvictionAllowed == other.mEvictionAllowed && this.mUseReservedSpace == other.mUseReservedSpace;
    }

    public int hashCode() {
        return Objects.hashCode(this.mSize, this.mLocation, this.mForceLocation, this.mEvictionAllowed, this.mUseReservedSpace);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("Location", this.mLocation).add("Size", this.mSize).add("ForceLocation", this.mForceLocation).add("EvictionAllowed", this.mEvictionAllowed).add("UseReservedSpace", this.mUseReservedSpace).toString();
    }
}

