/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.store.LocalPageStoreDir;
import alluxio.client.file.cache.store.LocalPageStoreOptions;
import alluxio.client.file.cache.store.MemoryPageStore;
import alluxio.client.file.cache.store.MemoryPageStoreDir;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.client.file.cache.store.RocksPageStore;
import alluxio.client.file.cache.store.RocksPageStoreDir;
import alluxio.conf.AlluxioConfiguration;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.util.io.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PageStoreDir {
    public static final Logger LOG = LoggerFactory.getLogger(RocksPageStore.class);

    public static List<PageStoreDir> createPageStoreDirs(AlluxioConfiguration conf) throws IOException {
        return PageStoreOptions.create(conf).stream().map(options -> PageStoreDir.createPageStoreDir(conf, options)).collect(ImmutableList.toImmutableList());
    }

    public static PageStoreDir createPageStoreDir(AlluxioConfiguration conf, PageStoreOptions pageStoreOptions) {
        switch (pageStoreOptions.getType()) {
            case LOCAL: {
                Preconditions.checkState(pageStoreOptions instanceof LocalPageStoreOptions);
                return new LocalPageStoreDir((LocalPageStoreOptions)pageStoreOptions, PageStore.create(pageStoreOptions), CacheEvictor.create(conf));
            }
            case ROCKS: {
                return new RocksPageStoreDir(pageStoreOptions, PageStore.create(pageStoreOptions), CacheEvictor.create(conf));
            }
            case MEM: {
                return new MemoryPageStoreDir(pageStoreOptions, (MemoryPageStore)PageStore.create(pageStoreOptions), CacheEvictor.create(conf));
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized store type %s", pageStoreOptions.getType().name()));
    }

    public static String getFileBucket(int fileBuckets, String fileId) {
        return Integer.toString(Math.floorMod(fileId.hashCode(), fileBuckets));
    }

    public static void clear(Path rootPath) throws IOException {
        Files.createDirectories(rootPath, new FileAttribute[0]);
        LOG.info("Cleaning cache directory {}", (Object)rootPath);
        try (Stream<Path> stream = Files.list(rootPath);){
            stream.forEach(path -> {
                try {
                    FileUtils.deletePathRecursively(path.toString());
                }
                catch (IOException e) {
                    PageStore.Metrics.CACHE_CLEAN_ERRORS.inc();
                    LOG.warn("failed to delete {} in cache directory: {}", path, (Object)e.toString());
                }
            });
        }
    }

    public Path getRootPath();

    public PageStore getPageStore();

    public long getCapacityBytes();

    public void reset() throws IOException;

    public void scanPages(Consumer<Optional<PageInfo>> var1) throws IOException;

    public long getCachedBytes();

    public boolean putPage(PageInfo var1);

    public boolean putTempFile(String var1);

    public boolean reserve(int var1);

    public long deletePage(PageInfo var1);

    public long release(int var1);

    public boolean hasFile(String var1);

    public CacheEvictor getEvictor();

    public void close();
}

