/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.executor;

import alluxio.collections.ConcurrentHashSet;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class UniqueBlockingQueue<T>
extends AbstractQueue<T>
implements BlockingQueue<T> {
    private ConcurrentHashSet<T> mElementSet = new ConcurrentHashSet();
    private BlockingQueue<T> mBlockingQueue;

    public UniqueBlockingQueue(int capacity) {
        this.mBlockingQueue = new LinkedBlockingQueue<T>(capacity);
    }

    @Override
    public synchronized void put(T e) throws InterruptedException {
        if (!this.mElementSet.contains(e)) {
            this.mBlockingQueue.put(e);
            this.mElementSet.add(e);
        }
    }

    @Override
    public synchronized boolean offer(T e) {
        if (this.mElementSet.contains(e)) {
            return false;
        }
        if (this.mBlockingQueue.offer(e)) {
            this.mElementSet.add(e);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.mElementSet.contains(e)) {
            return false;
        }
        if (this.mBlockingQueue.offer(e, timeout, unit)) {
            this.mElementSet.add(e);
            return true;
        }
        return false;
    }

    @Override
    public T take() throws InterruptedException {
        T e = this.mBlockingQueue.take();
        this.mElementSet.remove(e);
        return e;
    }

    @Override
    public int remainingCapacity() {
        return this.mBlockingQueue.remainingCapacity();
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        int numberOfElements = this.mBlockingQueue.drainTo(c, maxElements);
        if (numberOfElements > 0) {
            this.mElementSet.removeAll(c);
        }
        return numberOfElements;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator iter = this.mBlockingQueue.iterator();
        Iterator it = new Iterator<T>(){
            private T mLastElem = null;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                this.mLastElem = iter.next();
                return this.mLastElem;
            }

            @Override
            public void remove() {
                iter.remove();
                if (this.mLastElem != null) {
                    UniqueBlockingQueue.this.mElementSet.remove(this.mLastElem);
                }
                this.mLastElem = null;
            }
        };
        return it;
    }

    @Override
    public int size() {
        return this.mBlockingQueue.size();
    }

    @Override
    public T poll() {
        Object e = this.mBlockingQueue.poll();
        if (e != null) {
            this.mElementSet.remove(e);
        }
        return (T)e;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        T e = this.mBlockingQueue.poll(timeout, unit);
        if (e != null) {
            this.mElementSet.remove(e);
        }
        return e;
    }

    @Override
    public T peek() {
        return (T)this.mBlockingQueue.peek();
    }
}

