/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.raptor.legacy.metadata.DatabaseConfig;
import io.trino.plugin.raptor.legacy.metadata.ForMetadata;
import io.trino.plugin.raptor.legacy.metadata.H2DatabaseConfig;
import io.trino.plugin.raptor.legacy.metadata.H2ShardDao;
import io.trino.plugin.raptor.legacy.metadata.JdbcDatabaseConfig;
import io.trino.plugin.raptor.legacy.metadata.MySqlShardDao;
import io.trino.plugin.raptor.legacy.metadata.ShardDao;
import io.trino.plugin.raptor.legacy.util.DaoSupplier;
import java.sql.DriverManager;
import javax.inject.Singleton;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Jdbi;

public class DatabaseMetadataModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder ignored) {
        this.install(ConditionalModule.conditionalModule(DatabaseConfig.class, config -> "mysql".equals(config.getDatabaseType()), (Module)new MySqlModule()));
        this.install(ConditionalModule.conditionalModule(DatabaseConfig.class, config -> "h2".equals(config.getDatabaseType()), (Module)new H2Module()));
    }

    private static class MySqlModule
    implements Module {
        private MySqlModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcDatabaseConfig.class);
        }

        @Provides
        @Singleton
        @ForMetadata
        public static ConnectionFactory createConnectionFactory(JdbcDatabaseConfig config) {
            String url = config.getUrl();
            return () -> DriverManager.getConnection(url);
        }

        @Provides
        @Singleton
        public static DaoSupplier<ShardDao> createShardDaoSupplier(@ForMetadata Jdbi dbi) {
            return new DaoSupplier<ShardDao>(dbi, MySqlShardDao.class);
        }
    }

    private static class H2Module
    implements Module {
        private H2Module() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(H2DatabaseConfig.class);
        }

        @Provides
        @Singleton
        @ForMetadata
        public static ConnectionFactory createConnectionFactory(H2DatabaseConfig config) {
            String url = String.format("jdbc:h2:%s;DB_CLOSE_DELAY=-1", config.getFilename());
            return () -> DriverManager.getConnection(url);
        }

        @Provides
        @Singleton
        public static DaoSupplier<ShardDao> createShardDaoSupplier(@ForMetadata Jdbi dbi) {
            return new DaoSupplier<ShardDao>(dbi, H2ShardDao.class);
        }
    }
}

