/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.util;

import io.trino.plugin.raptor.legacy.util.DatabaseUtil;
import java.util.Objects;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class DaoSupplier<T> {
    private final Class<? extends T> type;
    private final T dao;

    public <X extends T> DaoSupplier(Jdbi dbi, Class<X> type) {
        Objects.requireNonNull(dbi, "dbi is null");
        Objects.requireNonNull(type, "type is null");
        this.type = type;
        this.dao = DatabaseUtil.onDemandDao(dbi, type);
    }

    public T onDemand() {
        return this.dao;
    }

    public T attach(Handle handle) {
        return (T)handle.attach(this.type);
    }
}

