/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.memory.MemoryInput;
import io.trino.filesystem.memory.MemoryTrinoInputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public class MemoryInputFile
implements TrinoInputFile {
    private final String location;
    private final Slice data;

    public MemoryInputFile(String location, Slice data) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.data = Objects.requireNonNull(data, "data is null");
    }

    @Override
    public TrinoInput newInput() throws IOException {
        return new MemoryInput(this.location, this.data);
    }

    @Override
    public TrinoInputStream newStream() throws IOException {
        return new MemoryTrinoInputStream(this.data);
    }

    @Override
    public long length() throws IOException {
        return this.data.length();
    }

    @Override
    public Instant lastModified() throws IOException {
        return Instant.EPOCH;
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    @Override
    public String location() {
        return this.location;
    }

    public String toString() {
        return this.location();
    }
}

