/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import java.nio.ByteBuffer;
import org.apache.pinot.segment.local.customobject.ValueLongPair;

public class StringLongPair
extends ValueLongPair<String> {
    public StringLongPair(String value, long time) {
        super(value, time);
    }

    public static StringLongPair fromBytes(byte[] bytes) {
        return StringLongPair.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    public static StringLongPair fromByteBuffer(ByteBuffer byteBuffer) {
        int len = byteBuffer.getInt();
        byte[] bytes = new byte[len];
        byteBuffer.get(bytes);
        return new StringLongPair(new String(bytes), byteBuffer.getLong());
    }

    @Override
    public byte[] toBytes() {
        int len = ((String)((Object)this._value)).length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + len + 8);
        byteBuffer.putInt(len);
        byteBuffer.put(((String)((Object)this._value)).getBytes());
        byteBuffer.putLong(this._time);
        return byteBuffer.array();
    }
}

