/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.immutable;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.indexsegment.immutable.EmptyIndexSegment;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentImpl;
import org.apache.pinot.segment.local.segment.index.column.PhysicalColumnIndexContainer;
import org.apache.pinot.segment.local.segment.index.converter.SegmentFormatConverterFactory;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.SegmentPreProcessor;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexContainer;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.converter.SegmentFormatConverter;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.IndexingOverrides;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoader;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderContext;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderRegistry;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableSegmentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableSegmentLoader.class);

    private ImmutableSegmentLoader() {
    }

    public static ImmutableSegment load(File indexDir, ReadMode readMode) throws Exception {
        IndexLoadingConfig defaultIndexLoadingConfig = new IndexLoadingConfig();
        defaultIndexLoadingConfig.setReadMode(readMode);
        return ImmutableSegmentLoader.load(indexDir, defaultIndexLoadingConfig, null, false);
    }

    public static ImmutableSegment load(File indexDir, IndexLoadingConfig indexLoadingConfig) throws Exception {
        return ImmutableSegmentLoader.load(indexDir, indexLoadingConfig, null, true);
    }

    public static ImmutableSegment load(File indexDir, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        return ImmutableSegmentLoader.load(indexDir, indexLoadingConfig, schema, true);
    }

    public static ImmutableSegment load(File indexDir, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema, boolean needPreprocess) throws Exception {
        Preconditions.checkArgument((boolean)indexDir.isDirectory(), (String)"Index directory: %s does not exist or is not a directory", (Object)indexDir);
        SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(indexDir);
        if (segmentMetadata.getTotalDocs() == 0) {
            return new EmptyIndexSegment(segmentMetadata);
        }
        if (schema != null) {
            schema = SegmentGeneratorConfig.updateSchemaWithTimestampIndexes((Schema)schema, (Map)SegmentGeneratorConfig.extractTimestampIndexConfigsFromTableConfig((TableConfig)indexLoadingConfig.getTableConfig()));
        }
        if (needPreprocess) {
            ImmutableSegmentLoader.preprocess(indexDir, indexLoadingConfig, schema);
        }
        String segmentName = segmentMetadata.getName();
        SegmentDirectoryLoaderContext segmentLoaderContext = new SegmentDirectoryLoaderContext.Builder().setTableConfig(indexLoadingConfig.getTableConfig()).setSchema(schema).setInstanceId(indexLoadingConfig.getInstanceId()).setSegmentName(segmentName).setSegmentCrc(segmentMetadata.getCrc()).setSegmentDirectoryConfigs(indexLoadingConfig.getSegmentDirectoryConfigs()).build();
        SegmentDirectoryLoader segmentLoader = SegmentDirectoryLoaderRegistry.getSegmentDirectoryLoader((String)indexLoadingConfig.getSegmentDirectoryLoader());
        SegmentDirectory segmentDirectory = segmentLoader.load(indexDir.toURI(), segmentLoaderContext);
        try {
            return ImmutableSegmentLoader.load(segmentDirectory, indexLoadingConfig, schema);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load segment: {} with SegmentDirectory", (Object)segmentName, (Object)e);
            segmentDirectory.close();
            throw e;
        }
    }

    public static void preprocess(File indexDir, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        Preconditions.checkArgument((boolean)indexDir.isDirectory(), (String)"Index directory: %s does not exist or is not a directory", (Object)indexDir);
        SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(indexDir);
        if (segmentMetadata.getTotalDocs() > 0) {
            ImmutableSegmentLoader.convertSegmentFormat(indexDir, indexLoadingConfig, segmentMetadata);
            ImmutableSegmentLoader.preprocessSegment(indexDir, segmentMetadata.getName(), segmentMetadata.getCrc(), indexLoadingConfig, schema);
        }
    }

    public static ImmutableSegment load(SegmentDirectory segmentDirectory, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        SegmentMetadataImpl segmentMetadata = segmentDirectory.getSegmentMetadata();
        if (segmentMetadata.getTotalDocs() == 0) {
            return new EmptyIndexSegment(segmentMetadata);
        }
        Map columnMetadataMap = segmentMetadata.getColumnMetadataMap();
        if (schema != null) {
            schema = SegmentGeneratorConfig.updateSchemaWithTimestampIndexes((Schema)schema, (Map)SegmentGeneratorConfig.extractTimestampIndexConfigsFromTableConfig((TableConfig)indexLoadingConfig.getTableConfig()));
            HashSet columnsInMetadata = new HashSet(columnMetadataMap.keySet());
            columnsInMetadata.removeIf(arg_0 -> ((Schema)schema).hasColumn(arg_0));
            if (!columnsInMetadata.isEmpty()) {
                LOGGER.info("Skip loading columns only exist in metadata but not in schema: {}", columnsInMetadata);
                for (String column : columnsInMetadata) {
                    segmentMetadata.removeColumn(column);
                }
            }
        }
        URI indexDirURI = segmentDirectory.getIndexDir();
        String scheme = indexDirURI.getScheme();
        File localIndexDir = null;
        if (scheme != null && scheme.equalsIgnoreCase("file")) {
            localIndexDir = new File(indexDirURI);
        }
        SegmentDirectory.Reader segmentReader = segmentDirectory.createReader();
        HashMap<String, ColumnIndexContainer> indexContainerMap = new HashMap<String, ColumnIndexContainer>();
        for (Map.Entry entry : columnMetadataMap.entrySet()) {
            indexContainerMap.put((String)entry.getKey(), new PhysicalColumnIndexContainer(segmentReader, (ColumnMetadata)entry.getValue(), indexLoadingConfig, localIndexDir, IndexingOverrides.getIndexReaderProvider()));
        }
        String segmentName = segmentMetadata.getName();
        Schema segmentSchema = segmentMetadata.getSchema();
        VirtualColumnProviderFactory.addBuiltInVirtualColumnsToSegmentSchema(segmentSchema, segmentName);
        for (FieldSpec fieldSpec : segmentSchema.getAllFieldSpecs()) {
            if (!fieldSpec.isVirtualColumn()) continue;
            String columnName = fieldSpec.getName();
            VirtualColumnContext context = new VirtualColumnContext(fieldSpec, segmentMetadata.getTotalDocs());
            VirtualColumnProvider provider = VirtualColumnProviderFactory.buildProvider(context);
            indexContainerMap.put(columnName, provider.buildColumnIndexContainer(context));
            columnMetadataMap.put(columnName, provider.buildMetadata(context));
        }
        StarTreeIndexContainer starTreeIndexContainer = null;
        if (segmentMetadata.getStarTreeV2MetadataList() != null && localIndexDir != null) {
            starTreeIndexContainer = new StarTreeIndexContainer(SegmentDirectoryPaths.findSegmentDirectory((File)localIndexDir), segmentMetadata, indexContainerMap, indexLoadingConfig.getReadMode());
        }
        ImmutableSegmentImpl segment = new ImmutableSegmentImpl(segmentDirectory, segmentMetadata, indexContainerMap, starTreeIndexContainer);
        LOGGER.info("Successfully loaded segment: {} with SegmentDirectory", (Object)segmentName);
        return segment;
    }

    public static boolean needPreprocess(SegmentDirectory segmentDirectory, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        if (ImmutableSegmentLoader.needConvertSegmentFormat(indexLoadingConfig, segmentDirectory.getSegmentMetadata())) {
            return true;
        }
        SegmentPreProcessor preProcessor = new SegmentPreProcessor(segmentDirectory, indexLoadingConfig, schema);
        return preProcessor.needProcess();
    }

    private static boolean needConvertSegmentFormat(IndexLoadingConfig indexLoadingConfig, SegmentMetadataImpl segmentMetadata) {
        SegmentVersion segmentVersionToLoad = indexLoadingConfig.getSegmentVersion();
        return segmentVersionToLoad != null && segmentVersionToLoad != segmentMetadata.getVersion();
    }

    private static void convertSegmentFormat(File indexDir, IndexLoadingConfig indexLoadingConfig, SegmentMetadataImpl localSegmentMetadata) throws Exception {
        SegmentVersion segmentVersionToLoad = indexLoadingConfig.getSegmentVersion();
        if (segmentVersionToLoad == null || SegmentDirectoryPaths.segmentDirectoryFor((File)indexDir, (SegmentVersion)segmentVersionToLoad).isDirectory()) {
            return;
        }
        SegmentVersion segmentVersionOnDisk = localSegmentMetadata.getVersion();
        if (segmentVersionOnDisk == segmentVersionToLoad) {
            return;
        }
        String segmentName = indexDir.getName();
        LOGGER.info("Segment: {} needs to be converted from version: {} to {}", new Object[]{segmentName, segmentVersionOnDisk, segmentVersionToLoad});
        SegmentFormatConverter converter = SegmentFormatConverterFactory.getConverter(segmentVersionOnDisk, segmentVersionToLoad);
        LOGGER.info("Using converter: {} to up-convert segment: {}", (Object)converter.getClass().getName(), (Object)segmentName);
        converter.convert(indexDir);
        LOGGER.info("Successfully up-converted segment: {} from version: {} to {}", new Object[]{segmentName, segmentVersionOnDisk, segmentVersionToLoad});
    }

    private static void preprocessSegment(File indexDir, String segmentName, String segmentCrc, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        PinotConfiguration segmentDirectoryConfigs = indexLoadingConfig.getSegmentDirectoryConfigs();
        SegmentDirectoryLoaderContext segmentLoaderContext = new SegmentDirectoryLoaderContext.Builder().setTableConfig(indexLoadingConfig.getTableConfig()).setSchema(schema).setInstanceId(indexLoadingConfig.getInstanceId()).setSegmentName(segmentName).setSegmentCrc(segmentCrc).setSegmentDirectoryConfigs(segmentDirectoryConfigs).build();
        SegmentDirectory segmentDirectory = SegmentDirectoryLoaderRegistry.getDefaultSegmentDirectoryLoader().load(indexDir.toURI(), segmentLoaderContext);
        try (SegmentPreProcessor preProcessor = new SegmentPreProcessor(segmentDirectory, indexLoadingConfig, schema);){
            preProcessor.process();
        }
    }
}

