/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableFST;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableFSTImpl;
import org.apache.pinot.segment.local.utils.nativefst.utils.RealTimeRegexpMatcher;
import org.apache.pinot.segment.spi.index.mutable.MutableTextIndex;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class NativeMutableFSTIndex
implements MutableTextIndex {
    private final String _column;
    private final MutableFST _fst;
    private final ReentrantReadWriteLock.ReadLock _readLock;
    private final ReentrantReadWriteLock.WriteLock _writeLock;
    private int _dictId;

    public NativeMutableFSTIndex(String column) {
        this._column = column;
        this._fst = new MutableFSTImpl();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this._readLock = readWriteLock.readLock();
        this._writeLock = readWriteLock.writeLock();
    }

    public void add(String document) {
        this._writeLock.lock();
        try {
            this._fst.addPath(document, this._dictId);
            ++this._dictId;
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableRoaringBitmap getDictIds(String searchQuery) {
        RoaringBitmapWriter writer = RoaringBitmapWriter.bufferWriter().get();
        this._readLock.lock();
        try {
            RealTimeRegexpMatcher.regexMatch(searchQuery, this._fst, arg_0 -> ((RoaringBitmapWriter)writer).add(arg_0));
            ImmutableRoaringBitmap immutableRoaringBitmap = (ImmutableRoaringBitmap)writer.get();
            return immutableRoaringBitmap;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public MutableRoaringBitmap getDocIds(String searchQuery) {
        throw new UnsupportedOperationException("getDocIds is not supported for NativeMutableFSTIndex");
    }

    public void close() throws IOException {
    }
}

