/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TimestampIndexGranularity;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class ExpressionTransformer
implements RecordTransformer {
    @VisibleForTesting
    final LinkedHashMap<String, FunctionEvaluator> _expressionEvaluators = new LinkedHashMap();

    public ExpressionTransformer(TableConfig tableConfig, Schema schema) {
        HashMap<String, FunctionEvaluator> expressionEvaluators = new HashMap<String, FunctionEvaluator>();
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getTransformConfigs() != null) {
            for (TransformConfig transformConfig : tableConfig.getIngestionConfig().getTransformConfigs()) {
                FunctionEvaluator previous = expressionEvaluators.put(transformConfig.getColumnName(), FunctionEvaluatorFactory.getExpressionEvaluator(transformConfig.getTransformFunction()));
                Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"Cannot set more than one ingestion transform function on column: %s.", (Object)transformConfig.getColumnName());
            }
        }
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            FunctionEvaluator functionEvaluator;
            String fieldName = fieldSpec.getName();
            if (fieldSpec.isVirtualColumn() || expressionEvaluators.containsKey(fieldName) || (functionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(fieldSpec)) == null) continue;
            expressionEvaluators.put(fieldName, functionEvaluator);
        }
        if (tableConfig.getFieldConfigList() != null) {
            for (FieldConfig fieldConfig : tableConfig.getFieldConfigList()) {
                if (!fieldConfig.getIndexTypes().contains(FieldConfig.IndexType.TIMESTAMP)) continue;
                for (TimestampIndexGranularity granularity : fieldConfig.getTimestampConfig().getGranularities()) {
                    expressionEvaluators.put(TimestampIndexGranularity.getColumnNameWithGranularity((String)fieldConfig.getName(), (TimestampIndexGranularity)granularity), FunctionEvaluatorFactory.getExpressionEvaluator(TimestampIndexGranularity.getTransformExpression((String)fieldConfig.getName(), (TimestampIndexGranularity)granularity)));
                }
            }
        }
        HashSet<String> discoveredNames = new HashSet<String>();
        for (Map.Entry entry : expressionEvaluators.entrySet()) {
            String columnName = (String)entry.getKey();
            if (this._expressionEvaluators.containsKey(columnName)) continue;
            this.topologicalSort(columnName, expressionEvaluators, discoveredNames);
        }
    }

    private void topologicalSort(String column, Map<String, FunctionEvaluator> expressionEvaluators, Set<String> discoveredNames) {
        FunctionEvaluator functionEvaluator = expressionEvaluators.get(column);
        if (functionEvaluator == null) {
            return;
        }
        if (discoveredNames.add(column)) {
            List<String> arguments = functionEvaluator.getArguments();
            for (String arg : arguments) {
                if (this._expressionEvaluators.containsKey(arg)) continue;
                this.topologicalSort(arg, expressionEvaluators, discoveredNames);
            }
        } else {
            throw new IllegalStateException("Expression cycle found for column '" + column + "' in Ingestion Transform Function definitions.");
        }
        this._expressionEvaluators.put(column, functionEvaluator);
        discoveredNames.remove(column);
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, FunctionEvaluator> entry : this._expressionEvaluators.entrySet()) {
            String column = entry.getKey();
            FunctionEvaluator transformFunctionEvaluator = entry.getValue();
            if (record.getValue(column) != null) continue;
            Object result = transformFunctionEvaluator.evaluate(record);
            record.putValue(column, result);
        }
        return record;
    }
}

