/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkSVForwardIndexWriter;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkSVForwardIndexWriterV4;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkWriter;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class MultiValueFixedByteRawIndexCreator
implements ForwardIndexCreator {
    private static final int DEFAULT_NUM_DOCS_PER_CHUNK = 1000;
    private static final int TARGET_MAX_CHUNK_SIZE = 0x100000;
    private final VarByteChunkWriter _indexWriter;
    private final FieldSpec.DataType _valueType;

    public MultiValueFixedByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxNumberOfMultiValueElements) throws IOException {
        this(baseIndexDir, compressionType, column, totalDocs, valueType, maxNumberOfMultiValueElements, false, 2);
    }

    public MultiValueFixedByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxNumberOfMultiValueElements, boolean deriveNumDocsPerChunk, int writerVersion) throws IOException {
        File file = new File(baseIndexDir, column + ".mv.raw.fwd");
        int totalMaxLength = 4 + maxNumberOfMultiValueElements * valueType.getStoredType().size();
        int numDocsPerChunk = deriveNumDocsPerChunk ? Math.max(0x100000 / (totalMaxLength + 4), 1) : 1000;
        this._indexWriter = writerVersion < 4 ? new VarByteChunkSVForwardIndexWriter(file, compressionType, totalDocs, numDocsPerChunk, totalMaxLength, writerVersion) : new VarByteChunkSVForwardIndexWriterV4(file, compressionType, 0x100000);
        this._valueType = valueType;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return false;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public void putIntMV(int[] values) {
        byte[] bytes = new byte[4 + values.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(values.length);
        for (int value : values) {
            byteBuffer.putInt(value);
        }
        this._indexWriter.putBytes(bytes);
    }

    public void putLongMV(long[] values) {
        byte[] bytes = new byte[4 + values.length * 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(values.length);
        for (long value : values) {
            byteBuffer.putLong(value);
        }
        this._indexWriter.putBytes(bytes);
    }

    public void putFloatMV(float[] values) {
        byte[] bytes = new byte[4 + values.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(values.length);
        for (float value : values) {
            byteBuffer.putFloat(value);
        }
        this._indexWriter.putBytes(bytes);
    }

    public void putDoubleMV(double[] values) {
        byte[] bytes = new byte[4 + values.length * 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(values.length);
        for (double value : values) {
            byteBuffer.putDouble(value);
        }
        this._indexWriter.putBytes(bytes);
    }

    public void close() throws IOException {
        this._indexWriter.close();
    }
}

