/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.segment.local.segment.store.TextIndexUtils;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TimestampIndexGranularity;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.ReadMode;

public class IndexLoadingConfig {
    private static final int DEFAULT_REALTIME_AVG_MULTI_VALUE_COUNT = 2;
    public static final String READ_MODE_KEY = "readMode";
    private ReadMode _readMode = ReadMode.DEFAULT_MODE;
    private List<String> _sortedColumns = Collections.emptyList();
    private Set<String> _invertedIndexColumns = new HashSet<String>();
    private Set<String> _rangeIndexColumns = new HashSet<String>();
    private int _rangeIndexVersion = 2;
    private Set<String> _textIndexColumns = new HashSet<String>();
    private Set<String> _fstIndexColumns = new HashSet<String>();
    private FSTType _fstIndexType = FSTType.LUCENE;
    private Set<String> _jsonIndexColumns = new HashSet<String>();
    private Map<String, H3IndexConfig> _h3IndexConfigs = new HashMap<String, H3IndexConfig>();
    private Set<String> _noDictionaryColumns = new HashSet<String>();
    private Map<String, String> _noDictionaryConfig = new HashMap<String, String>();
    private Set<String> _varLengthDictionaryColumns = new HashSet<String>();
    private Set<String> _onHeapDictionaryColumns = new HashSet<String>();
    private Map<String, BloomFilterConfig> _bloomFilterConfigs = new HashMap<String, BloomFilterConfig>();
    private boolean _enableDynamicStarTreeCreation;
    private List<StarTreeIndexConfig> _starTreeIndexConfigs;
    private boolean _enableDefaultStarTree;
    private SegmentVersion _segmentVersion;
    private ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode = ColumnMinMaxValueGeneratorMode.DEFAULT_MODE;
    private int _realtimeAvgMultiValueCount = 2;
    private boolean _enableSplitCommit;
    private boolean _isRealtimeOffHeapAllocation;
    private boolean _isDirectRealtimeOffHeapAllocation;
    private boolean _enableSplitCommitEndWithMetadata;
    private String _segmentStoreURI;
    private Map<String, Map<String, String>> _columnProperties = new HashMap<String, Map<String, String>>();
    private TableConfig _tableConfig;
    private String _segmentDirectoryLoader;
    private String _instanceId;

    public IndexLoadingConfig(InstanceDataManagerConfig instanceDataManagerConfig, TableConfig tableConfig) {
        this.extractFromInstanceConfig(instanceDataManagerConfig);
        this.extractFromTableConfig(tableConfig);
        this._tableConfig = tableConfig;
    }

    private void extractFromTableConfig(TableConfig tableConfig) {
        String columnMinMaxValueGeneratorMode;
        List onHeapDictionaryColumns;
        List varLengthDictionaryColumns;
        Map noDictionaryConfig;
        List fieldConfigList;
        List noDictionaryColumns;
        Map bloomFilterConfigs;
        List rangeIndexColumns;
        List jsonIndexColumns;
        List invertedIndexColumns;
        List sortedColumns;
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        String tableReadMode = indexingConfig.getLoadMode();
        if (tableReadMode != null) {
            this._readMode = ReadMode.getEnum((String)tableReadMode);
        }
        if ((sortedColumns = indexingConfig.getSortedColumn()) != null) {
            this._sortedColumns = sortedColumns;
        }
        if ((invertedIndexColumns = indexingConfig.getInvertedIndexColumns()) != null) {
            this._invertedIndexColumns.addAll(invertedIndexColumns);
        }
        if ((jsonIndexColumns = indexingConfig.getJsonIndexColumns()) != null) {
            this._jsonIndexColumns.addAll(jsonIndexColumns);
        }
        if ((rangeIndexColumns = indexingConfig.getRangeIndexColumns()) != null) {
            this._rangeIndexColumns.addAll(rangeIndexColumns);
        }
        this._rangeIndexVersion = indexingConfig.getRangeIndexVersion();
        this._fstIndexType = indexingConfig.getFSTIndexType();
        List bloomFilterColumns = indexingConfig.getBloomFilterColumns();
        if (bloomFilterColumns != null) {
            for (String bloomFilterColumn : bloomFilterColumns) {
                this._bloomFilterConfigs.put(bloomFilterColumn, new BloomFilterConfig(0.05, 0, false));
            }
        }
        if ((bloomFilterConfigs = indexingConfig.getBloomFilterConfigs()) != null) {
            this._bloomFilterConfigs.putAll(bloomFilterConfigs);
        }
        if ((noDictionaryColumns = indexingConfig.getNoDictionaryColumns()) != null) {
            this._noDictionaryColumns.addAll(noDictionaryColumns);
        }
        if ((fieldConfigList = tableConfig.getFieldConfigList()) != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                this._columnProperties.put(fieldConfig.getName(), fieldConfig.getProperties());
            }
        }
        this.extractTextIndexColumnsFromTableConfig(tableConfig);
        this.extractFSTIndexColumnsFromTableConfig(tableConfig);
        this.extractH3IndexConfigsFromTableConfig(tableConfig);
        Map timestampIndexConfigs = SegmentGeneratorConfig.extractTimestampIndexConfigsFromTableConfig((TableConfig)tableConfig);
        if (!timestampIndexConfigs.isEmpty()) {
            ArrayList<TransformConfig> transformConfigs;
            IngestionConfig ingestionConfig = tableConfig.getIngestionConfig();
            if (ingestionConfig == null) {
                ingestionConfig = new IngestionConfig();
                tableConfig.setIngestionConfig(ingestionConfig);
            }
            if ((transformConfigs = ingestionConfig.getTransformConfigs()) == null) {
                transformConfigs = new ArrayList<TransformConfig>();
                ingestionConfig.setTransformConfigs(transformConfigs);
            }
            for (Map.Entry entry : timestampIndexConfigs.entrySet()) {
                String column = (String)entry.getKey();
                for (TimestampIndexGranularity granularity : (List)entry.getValue()) {
                    String columnNameWithGranularity = TimestampIndexGranularity.getColumnNameWithGranularity((String)column, (TimestampIndexGranularity)granularity);
                    TransformConfig transformConfig = new TransformConfig(columnNameWithGranularity, TimestampIndexGranularity.getTransformExpression((String)column, (TimestampIndexGranularity)granularity));
                    transformConfigs.add(transformConfig);
                    this._rangeIndexColumns.add(columnNameWithGranularity);
                }
            }
        }
        if ((noDictionaryConfig = indexingConfig.getNoDictionaryConfig()) != null) {
            this._noDictionaryConfig.putAll(noDictionaryConfig);
        }
        if ((varLengthDictionaryColumns = indexingConfig.getVarLengthDictionaryColumns()) != null) {
            this._varLengthDictionaryColumns.addAll(varLengthDictionaryColumns);
        }
        if ((onHeapDictionaryColumns = indexingConfig.getOnHeapDictionaryColumns()) != null) {
            this._onHeapDictionaryColumns.addAll(onHeapDictionaryColumns);
        }
        this._enableDynamicStarTreeCreation = indexingConfig.isEnableDynamicStarTreeCreation();
        this._starTreeIndexConfigs = indexingConfig.getStarTreeIndexConfigs();
        this._enableDefaultStarTree = indexingConfig.isEnableDefaultStarTree();
        String tableSegmentVersion = indexingConfig.getSegmentFormatVersion();
        if (tableSegmentVersion != null) {
            this._segmentVersion = SegmentVersion.valueOf((String)tableSegmentVersion.toLowerCase());
        }
        if ((columnMinMaxValueGeneratorMode = indexingConfig.getColumnMinMaxValueGeneratorMode()) != null) {
            this._columnMinMaxValueGeneratorMode = ColumnMinMaxValueGeneratorMode.valueOf(columnMinMaxValueGeneratorMode.toUpperCase());
        }
    }

    private void extractTextIndexColumnsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                String column = fieldConfig.getName();
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.TEXT) continue;
                this._textIndexColumns.add(column);
                Map propertiesMap = fieldConfig.getProperties();
                if (!TextIndexUtils.isFstTypeNative(propertiesMap)) continue;
                this._fstIndexType = FSTType.NATIVE;
            }
        }
    }

    private void extractFSTIndexColumnsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                String column = fieldConfig.getName();
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.FST) continue;
                this._fstIndexColumns.add(column);
            }
        }
    }

    private void extractH3IndexConfigsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.H3) continue;
                this._h3IndexConfigs.put(fieldConfig.getName(), new H3IndexConfig(fieldConfig.getProperties()));
            }
        }
    }

    private void extractFromInstanceConfig(InstanceDataManagerConfig instanceDataManagerConfig) {
        String instanceSegmentVersion;
        if (instanceDataManagerConfig == null) {
            return;
        }
        this._instanceId = instanceDataManagerConfig.getInstanceId();
        ReadMode instanceReadMode = instanceDataManagerConfig.getReadMode();
        if (instanceReadMode != null) {
            this._readMode = instanceReadMode;
        }
        if ((instanceSegmentVersion = instanceDataManagerConfig.getSegmentFormatVersion()) != null) {
            this._segmentVersion = SegmentVersion.valueOf((String)instanceSegmentVersion.toLowerCase());
        }
        this._enableSplitCommit = instanceDataManagerConfig.isEnableSplitCommit();
        this._isRealtimeOffHeapAllocation = instanceDataManagerConfig.isRealtimeOffHeapAllocation();
        this._isDirectRealtimeOffHeapAllocation = instanceDataManagerConfig.isDirectRealtimeOffHeapAllocation();
        String avgMultiValueCount = instanceDataManagerConfig.getAvgMultiValueCount();
        if (avgMultiValueCount != null) {
            this._realtimeAvgMultiValueCount = Integer.valueOf(avgMultiValueCount);
        }
        this._enableSplitCommitEndWithMetadata = instanceDataManagerConfig.isEnableSplitCommitEndWithMetadata();
        this._segmentStoreURI = instanceDataManagerConfig.getConfig().getProperty("segment.store.uri");
        this._segmentDirectoryLoader = instanceDataManagerConfig.getSegmentDirectoryLoader();
    }

    public IndexLoadingConfig() {
    }

    public ReadMode getReadMode() {
        return this._readMode;
    }

    public void setReadMode(ReadMode readMode) {
        this._readMode = readMode;
    }

    public List<String> getSortedColumns() {
        return this._sortedColumns;
    }

    public Set<String> getInvertedIndexColumns() {
        return this._invertedIndexColumns;
    }

    public Set<String> getRangeIndexColumns() {
        return this._rangeIndexColumns;
    }

    public int getRangeIndexVersion() {
        return this._rangeIndexVersion;
    }

    public FSTType getFSTIndexType() {
        return this._fstIndexType;
    }

    public Set<String> getTextIndexColumns() {
        return this._textIndexColumns;
    }

    public Set<String> getFSTIndexColumns() {
        return this._fstIndexColumns;
    }

    public Set<String> getJsonIndexColumns() {
        return this._jsonIndexColumns;
    }

    public Map<String, H3IndexConfig> getH3IndexConfigs() {
        return this._h3IndexConfigs;
    }

    public Map<String, Map<String, String>> getColumnProperties() {
        return this._columnProperties;
    }

    public void setColumnProperties(Map<String, Map<String, String>> columnProperties) {
        this._columnProperties = columnProperties;
    }

    @VisibleForTesting
    public void setInvertedIndexColumns(Set<String> invertedIndexColumns) {
        this._invertedIndexColumns = invertedIndexColumns;
    }

    @VisibleForTesting
    public void setRangeIndexColumns(Set<String> rangeIndexColumns) {
        this._rangeIndexColumns = rangeIndexColumns;
    }

    @VisibleForTesting
    public void setTextIndexColumns(Set<String> textIndexColumns) {
        this._textIndexColumns = textIndexColumns;
    }

    @VisibleForTesting
    public void setFSTIndexColumns(Set<String> fstIndexColumns) {
        this._fstIndexColumns = fstIndexColumns;
    }

    @VisibleForTesting
    public void setFSTIndexType(FSTType fstType) {
        this._fstIndexType = fstType;
    }

    @VisibleForTesting
    public void setJsonIndexColumns(Set<String> jsonIndexColumns) {
        this._jsonIndexColumns = jsonIndexColumns;
    }

    @VisibleForTesting
    public void setH3IndexConfigs(Map<String, H3IndexConfig> h3IndexConfigs) {
        this._h3IndexConfigs = h3IndexConfigs;
    }

    @VisibleForTesting
    public void setBloomFilterConfigs(Map<String, BloomFilterConfig> bloomFilterConfigs) {
        this._bloomFilterConfigs = bloomFilterConfigs;
    }

    @VisibleForTesting
    public void setOnHeapDictionaryColumns(Set<String> onHeapDictionaryColumns) {
        this._onHeapDictionaryColumns = onHeapDictionaryColumns;
    }

    public Set<String> getNoDictionaryColumns() {
        return this._noDictionaryColumns;
    }

    public Map<String, String> getnoDictionaryConfig() {
        return this._noDictionaryConfig;
    }

    public Set<String> getVarLengthDictionaryColumns() {
        return this._varLengthDictionaryColumns;
    }

    public Set<String> getOnHeapDictionaryColumns() {
        return this._onHeapDictionaryColumns;
    }

    public Map<String, BloomFilterConfig> getBloomFilterConfigs() {
        return this._bloomFilterConfigs;
    }

    public boolean isEnableDynamicStarTreeCreation() {
        return this._enableDynamicStarTreeCreation;
    }

    @Nullable
    public List<StarTreeIndexConfig> getStarTreeIndexConfigs() {
        return this._starTreeIndexConfigs;
    }

    public boolean isEnableDefaultStarTree() {
        return this._enableDefaultStarTree;
    }

    @Nullable
    public SegmentVersion getSegmentVersion() {
        return this._segmentVersion;
    }

    public void setSegmentVersion(SegmentVersion segmentVersion) {
        this._segmentVersion = segmentVersion;
    }

    public boolean isEnableSplitCommit() {
        return this._enableSplitCommit;
    }

    public boolean isEnableSplitCommitEndWithMetadata() {
        return this._enableSplitCommitEndWithMetadata;
    }

    public boolean isRealtimeOffHeapAllocation() {
        return this._isRealtimeOffHeapAllocation;
    }

    public boolean isDirectRealtimeOffHeapAllocation() {
        return this._isDirectRealtimeOffHeapAllocation;
    }

    public ColumnMinMaxValueGeneratorMode getColumnMinMaxValueGeneratorMode() {
        return this._columnMinMaxValueGeneratorMode;
    }

    public String getSegmentStoreURI() {
        return this._segmentStoreURI;
    }

    public void setColumnMinMaxValueGeneratorMode(ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode) {
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
    }

    public int getRealtimeAvgMultiValueCount() {
        return this._realtimeAvgMultiValueCount;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    @VisibleForTesting
    public void setTableConfig(TableConfig tableConfig) {
        this._tableConfig = tableConfig;
    }

    public String getSegmentDirectoryLoader() {
        return StringUtils.isNotBlank((CharSequence)this._segmentDirectoryLoader) ? this._segmentDirectoryLoader : "default";
    }

    public PinotConfiguration getSegmentDirectoryConfigs() {
        HashMap<String, ReadMode> props = new HashMap<String, ReadMode>();
        props.put(READ_MODE_KEY, this._readMode);
        return new PinotConfiguration(props);
    }

    public String getInstanceId() {
        return this._instanceId;
    }
}

