/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManager;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;

@ThreadSafe
public abstract class BaseTableUpsertMetadataManager
implements TableUpsertMetadataManager {
    protected String _tableNameWithType;
    protected List<String> _primaryKeyColumns;
    protected String _comparisonColumn;
    protected HashFunction _hashFunction;
    protected PartialUpsertHandler _partialUpsertHandler;
    protected ServerMetrics _serverMetrics;

    @Override
    public void init(TableConfig tableConfig, Schema schema, TableDataManager tableDataManager, ServerMetrics serverMetrics) {
        this._tableNameWithType = tableConfig.getTableName();
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        Preconditions.checkArgument((upsertConfig != null && upsertConfig.getMode() != UpsertConfig.Mode.NONE ? 1 : 0) != 0, (String)"Upsert must be enabled for table: %s", (Object)this._tableNameWithType);
        this._primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this._primaryKeyColumns) ? 1 : 0) != 0, (String)"Primary key columns must be configured for upsert enabled table: %s", (Object)this._tableNameWithType);
        this._comparisonColumn = upsertConfig.getComparisonColumn();
        if (this._comparisonColumn == null) {
            this._comparisonColumn = tableConfig.getValidationConfig().getTimeColumnName();
        }
        this._hashFunction = upsertConfig.getHashFunction();
        if (upsertConfig.getMode() == UpsertConfig.Mode.PARTIAL) {
            Map partialUpsertStrategies = upsertConfig.getPartialUpsertStrategies();
            Preconditions.checkArgument((partialUpsertStrategies != null ? 1 : 0) != 0, (String)"Partial-upsert strategies must be configured for partial-upsert enabled table: %s", (Object)this._tableNameWithType);
            this._partialUpsertHandler = new PartialUpsertHandler(schema, partialUpsertStrategies, upsertConfig.getDefaultPartialUpsertStrategy(), this._comparisonColumn);
        }
        this._serverMetrics = serverMetrics;
    }

    @Override
    public UpsertConfig.Mode getUpsertMode() {
        return this._partialUpsertHandler == null ? UpsertConfig.Mode.FULL : UpsertConfig.Mode.PARTIAL;
    }
}

