/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.segment.local.indexsegment.immutable.EmptyIndexSegment;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentImpl;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.local.upsert.UpsertUtils;
import org.apache.pinot.segment.local.utils.HashUtils;
import org.apache.pinot.segment.local.utils.SegmentLocks;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConcurrentMapPartitionUpsertMetadataManager
implements PartitionUpsertMetadataManager {
    private static final long OUT_OF_ORDER_EVENT_MIN_REPORT_INTERVAL_NS = TimeUnit.MINUTES.toNanos(1L);
    private final String _tableNameWithType;
    private final int _partitionId;
    private final List<String> _primaryKeyColumns;
    private final String _comparisonColumn;
    private final HashFunction _hashFunction;
    private final PartialUpsertHandler _partialUpsertHandler;
    private final ServerMetrics _serverMetrics;
    private final Logger _logger;
    @VisibleForTesting
    final ConcurrentHashMap<Object, RecordLocation> _primaryKeyToRecordLocationMap = new ConcurrentHashMap();
    @VisibleForTesting
    final Set<IndexSegment> _replacedSegments = ConcurrentHashMap.newKeySet();
    private final GenericRow _reuse = new GenericRow();
    private long _lastOutOfOrderEventReportTimeNs = Long.MIN_VALUE;
    private int _numOutOfOrderEvents = 0;

    public ConcurrentMapPartitionUpsertMetadataManager(String tableNameWithType, int partitionId, List<String> primaryKeyColumns, String comparisonColumn, HashFunction hashFunction, @Nullable PartialUpsertHandler partialUpsertHandler, ServerMetrics serverMetrics) {
        this._tableNameWithType = tableNameWithType;
        this._partitionId = partitionId;
        this._primaryKeyColumns = primaryKeyColumns;
        this._comparisonColumn = comparisonColumn;
        this._hashFunction = hashFunction;
        this._partialUpsertHandler = partialUpsertHandler;
        this._serverMetrics = serverMetrics;
        this._logger = LoggerFactory.getLogger((String)(tableNameWithType + "-" + partitionId + "-" + this.getClass().getSimpleName()));
    }

    @Override
    public List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    @Override
    public void addSegment(ImmutableSegment segment) {
        this.addSegment(segment, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void addSegment(ImmutableSegment segment, @Nullable ThreadSafeMutableRoaringBitmap validDocIds, @Nullable Iterator<RecordInfo> recordInfoIterator) {
        String segmentName = segment.getSegmentName();
        this._logger.info("Adding segment: {}, current primary key count: {}", (Object)segmentName, (Object)this._primaryKeyToRecordLocationMap.size());
        if (segment instanceof EmptyIndexSegment) {
            this._logger.info("Skip adding empty segment: {}", (Object)segmentName);
            return;
        }
        Lock segmentLock = SegmentLocks.getSegmentLock(this._tableNameWithType, segmentName);
        segmentLock.lock();
        try {
            Preconditions.checkArgument((boolean)(segment instanceof ImmutableSegmentImpl), (String)"Got unsupported segment implementation: {} for segment: {}, table: {}", segment.getClass(), (Object)segmentName, (Object)this._tableNameWithType);
            if (validDocIds == null) {
                validDocIds = new ThreadSafeMutableRoaringBitmap();
            }
            if (recordInfoIterator == null) {
                recordInfoIterator = UpsertUtils.getRecordInfoIterator(segment, this._primaryKeyColumns, this._comparisonColumn);
            }
            this.addOrReplaceSegment((ImmutableSegmentImpl)segment, validDocIds, recordInfoIterator, null, null);
        }
        finally {
            segmentLock.unlock();
        }
        int numPrimaryKeys = this._primaryKeyToRecordLocationMap.size();
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)numPrimaryKeys);
        this._logger.info("Finished adding segment: {}, current primary key count: {}", (Object)segmentName, (Object)numPrimaryKeys);
    }

    private void addOrReplaceSegment(ImmutableSegmentImpl segment, ThreadSafeMutableRoaringBitmap validDocIds, Iterator<RecordInfo> recordInfoIterator, @Nullable IndexSegment oldSegment, @Nullable MutableRoaringBitmap validDocIdsForOldSegment) {
        String segmentName = segment.getSegmentName();
        segment.enableUpsert(this, validDocIds);
        AtomicInteger numKeysInWrongSegment = new AtomicInteger();
        while (recordInfoIterator.hasNext()) {
            RecordInfo recordInfo = recordInfoIterator.next();
            this._primaryKeyToRecordLocationMap.compute(HashUtils.hashPrimaryKey(recordInfo.getPrimaryKey(), this._hashFunction), (primaryKey, currentRecordLocation) -> {
                if (currentRecordLocation != null) {
                    IndexSegment currentSegment = currentRecordLocation.getSegment();
                    int comparisonResult = recordInfo.getComparisonValue().compareTo(currentRecordLocation.getComparisonValue());
                    if (currentSegment == segment) {
                        if (comparisonResult >= 0) {
                            validDocIds.replace(currentRecordLocation.getDocId(), recordInfo.getDocId());
                            return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                        }
                        return currentRecordLocation;
                    }
                    if (currentSegment == oldSegment) {
                        if (comparisonResult >= 0) {
                            validDocIds.add(recordInfo.getDocId());
                            if (validDocIdsForOldSegment != null) {
                                validDocIdsForOldSegment.remove(currentRecordLocation.getDocId());
                            }
                            return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                        }
                        return currentRecordLocation;
                    }
                    String currentSegmentName = currentSegment.getSegmentName();
                    if (currentSegmentName.equals(segmentName)) {
                        numKeysInWrongSegment.getAndIncrement();
                        if (comparisonResult >= 0) {
                            validDocIds.add(recordInfo.getDocId());
                            return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                        }
                        return currentRecordLocation;
                    }
                    if (comparisonResult > 0 || comparisonResult == 0 && LLCSegmentName.isLowLevelConsumerSegmentName((String)segmentName) && LLCSegmentName.isLowLevelConsumerSegmentName((String)currentSegmentName) && LLCSegmentName.getSequenceNumber((String)segmentName) > LLCSegmentName.getSequenceNumber((String)currentSegmentName)) {
                        Objects.requireNonNull(currentSegment.getValidDocIds()).remove(currentRecordLocation.getDocId());
                        validDocIds.add(recordInfo.getDocId());
                        return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                    }
                    return currentRecordLocation;
                }
                validDocIds.add(recordInfo.getDocId());
                return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
            });
        }
        int numKeys = numKeysInWrongSegment.get();
        if (numKeys > 0) {
            this._logger.warn("Found {} primary keys in the wrong segment when adding segment: {}", (Object)numKeys, (Object)segmentName);
            this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.UPSERT_KEYS_IN_WRONG_SEGMENT, (long)numKeys);
        }
    }

    @Override
    public void addRecord(MutableSegment segment, RecordInfo recordInfo) {
        ThreadSafeMutableRoaringBitmap validDocIds = Objects.requireNonNull(segment.getValidDocIds());
        this._primaryKeyToRecordLocationMap.compute(HashUtils.hashPrimaryKey(recordInfo.getPrimaryKey(), this._hashFunction), (primaryKey, currentRecordLocation) -> {
            if (currentRecordLocation != null) {
                if (recordInfo.getComparisonValue().compareTo(currentRecordLocation.getComparisonValue()) >= 0) {
                    IndexSegment currentSegment = currentRecordLocation.getSegment();
                    int currentDocId = currentRecordLocation.getDocId();
                    if (segment == currentSegment) {
                        validDocIds.replace(currentDocId, recordInfo.getDocId());
                    } else {
                        Objects.requireNonNull(currentSegment.getValidDocIds()).remove(currentDocId);
                        validDocIds.add(recordInfo.getDocId());
                    }
                    return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
                }
                return currentRecordLocation;
            }
            validDocIds.add(recordInfo.getDocId());
            return new RecordLocation((IndexSegment)segment, recordInfo.getDocId(), recordInfo.getComparisonValue());
        });
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
    }

    @Override
    public void replaceSegment(ImmutableSegment segment, IndexSegment oldSegment) {
        this.replaceSegment(segment, null, null, oldSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void replaceSegment(ImmutableSegment segment, @Nullable ThreadSafeMutableRoaringBitmap validDocIds, @Nullable Iterator<RecordInfo> recordInfoIterator, IndexSegment oldSegment) {
        String segmentName = segment.getSegmentName();
        Preconditions.checkArgument((boolean)segmentName.equals(oldSegment.getSegmentName()), (String)"Cannot replace segment with different name for table: {}, old segment: {}, new segment: {}", (Object)this._tableNameWithType, (Object)oldSegment.getSegmentName(), (Object)segmentName);
        this._logger.info("Replacing {} segment: {}, current primary key count: {}", new Object[]{oldSegment instanceof ImmutableSegment ? "immutable" : "mutable", segmentName, this._primaryKeyToRecordLocationMap.size()});
        Lock segmentLock = SegmentLocks.getSegmentLock(this._tableNameWithType, segmentName);
        segmentLock.lock();
        try {
            MutableRoaringBitmap validDocIdsForOldSegment;
            MutableRoaringBitmap mutableRoaringBitmap = validDocIdsForOldSegment = oldSegment.getValidDocIds() != null ? oldSegment.getValidDocIds().getMutableRoaringBitmap() : null;
            if (segment instanceof EmptyIndexSegment) {
                this._logger.info("Skip adding empty segment: {}", (Object)segmentName);
            } else {
                Preconditions.checkArgument((boolean)(segment instanceof ImmutableSegmentImpl), (String)"Got unsupported segment implementation: {} for segment: {}, table: {}", segment.getClass(), (Object)segmentName, (Object)this._tableNameWithType);
                if (validDocIds == null) {
                    validDocIds = new ThreadSafeMutableRoaringBitmap();
                }
                if (recordInfoIterator == null) {
                    recordInfoIterator = UpsertUtils.getRecordInfoIterator(segment, this._primaryKeyColumns, this._comparisonColumn);
                }
                this.addOrReplaceSegment((ImmutableSegmentImpl)segment, validDocIds, recordInfoIterator, oldSegment, validDocIdsForOldSegment);
            }
            if (validDocIdsForOldSegment != null && !validDocIdsForOldSegment.isEmpty()) {
                int numKeysNotReplaced = validDocIdsForOldSegment.getCardinality();
                if (this._partialUpsertHandler != null) {
                    this._logger.warn("Found {} primary keys not replaced when replacing segment: {} for partial-upsert table. This can potentially cause inconsistency between replicas", (Object)numKeysNotReplaced, (Object)segmentName);
                    this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.PARTIAL_UPSERT_KEYS_NOT_REPLACED, (long)numKeysNotReplaced);
                } else {
                    this._logger.info("Found {} primary keys not replaced when replacing segment: {}", (Object)numKeysNotReplaced, (Object)segmentName);
                }
                this.removeSegment(oldSegment, validDocIdsForOldSegment);
            }
        }
        finally {
            segmentLock.unlock();
        }
        if (!(oldSegment instanceof EmptyIndexSegment)) {
            this._replacedSegments.add(oldSegment);
        }
        int numPrimaryKeys = this._primaryKeyToRecordLocationMap.size();
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)numPrimaryKeys);
        this._logger.info("Finished replacing segment: {}, current primary key count: {}", (Object)segmentName, (Object)numPrimaryKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSegment(IndexSegment segment) {
        String segmentName = segment.getSegmentName();
        this._logger.info("Removing {} segment: {}, current primary key count: {}", new Object[]{segment instanceof ImmutableSegment ? "immutable" : "mutable", segmentName, this._primaryKeyToRecordLocationMap.size()});
        if (this._replacedSegments.remove(segment)) {
            this._logger.info("Skip removing replaced segment: {}", (Object)segmentName);
            return;
        }
        Lock segmentLock = SegmentLocks.getSegmentLock(this._tableNameWithType, segmentName);
        segmentLock.lock();
        try {
            MutableRoaringBitmap validDocIds;
            MutableRoaringBitmap mutableRoaringBitmap = validDocIds = segment.getValidDocIds() != null ? segment.getValidDocIds().getMutableRoaringBitmap() : null;
            if (validDocIds == null || validDocIds.isEmpty()) {
                this._logger.info("Skip removing segment without valid docs: {}", (Object)segmentName);
                return;
            }
            this._logger.info("Removing {} primary keys for segment: {}", (Object)validDocIds.getCardinality(), (Object)segmentName);
            this.removeSegment(segment, validDocIds);
        }
        finally {
            segmentLock.unlock();
        }
        int numPrimaryKeys = this._primaryKeyToRecordLocationMap.size();
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)numPrimaryKeys);
        this._logger.info("Finished removing segment: {}, current primary key count: {}", (Object)segmentName, (Object)numPrimaryKeys);
    }

    private void removeSegment(IndexSegment segment, MutableRoaringBitmap validDocIds) {
        assert (!validDocIds.isEmpty());
        PrimaryKey primaryKey = new PrimaryKey(new Object[this._primaryKeyColumns.size()]);
        PeekableIntIterator iterator = validDocIds.getIntIterator();
        while (iterator.hasNext()) {
            int docId = iterator.next();
            UpsertUtils.getPrimaryKey(segment, this._primaryKeyColumns, docId, primaryKey);
            this._primaryKeyToRecordLocationMap.computeIfPresent(HashUtils.hashPrimaryKey(primaryKey, this._hashFunction), (pk, recordLocation) -> {
                if (recordLocation.getSegment() == segment) {
                    return null;
                }
                return recordLocation;
            });
        }
    }

    @Override
    public GenericRow updateRecord(GenericRow record, RecordInfo recordInfo) {
        if (this._partialUpsertHandler == null) {
            return record;
        }
        AtomicReference previousRecordReference = new AtomicReference();
        RecordLocation currentRecordLocation = this._primaryKeyToRecordLocationMap.computeIfPresent(HashUtils.hashPrimaryKey(recordInfo.getPrimaryKey(), this._hashFunction), (pk, recordLocation) -> {
            if (recordInfo.getComparisonValue().compareTo(recordLocation.getComparisonValue()) >= 0) {
                this._reuse.clear();
                previousRecordReference.set(recordLocation.getSegment().getRecord(recordLocation.getDocId(), this._reuse));
            }
            return recordLocation;
        });
        if (currentRecordLocation != null) {
            GenericRow previousRecord = (GenericRow)previousRecordReference.get();
            if (previousRecord != null) {
                return this._partialUpsertHandler.merge(previousRecord, record);
            }
            this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.PARTIAL_UPSERT_OUT_OF_ORDER, 1L);
            ++this._numOutOfOrderEvents;
            long currentTimeNs = System.nanoTime();
            if (currentTimeNs - this._lastOutOfOrderEventReportTimeNs > OUT_OF_ORDER_EVENT_MIN_REPORT_INTERVAL_NS) {
                this._logger.warn("Skipped {} out-of-order events for partial-upsert table (the last event has current comparison value: {}, record comparison value: {})", new Object[]{this._numOutOfOrderEvents, currentRecordLocation.getComparisonValue(), recordInfo.getComparisonValue()});
                this._lastOutOfOrderEventReportTimeNs = currentTimeNs;
                this._numOutOfOrderEvents = 0;
            }
            return record;
        }
        return record;
    }

    @Override
    public void close() {
        this._logger.info("Closing metadata manager for table {} and partition {}, current primary key count: {}", new Object[]{this._tableNameWithType, this._partitionId, this._primaryKeyToRecordLocationMap.size()});
    }

    @VisibleForTesting
    static class RecordLocation {
        private final IndexSegment _segment;
        private final int _docId;
        private final Comparable _comparisonValue;

        public RecordLocation(IndexSegment indexSegment, int docId, Comparable comparisonValue) {
            this._segment = indexSegment;
            this._docId = docId;
            this._comparisonValue = comparisonValue;
        }

        public IndexSegment getSegment() {
            return this._segment;
        }

        public int getDocId() {
            return this._docId;
        }

        public Comparable getComparisonValue() {
            return this._comparisonValue;
        }
    }
}

