/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoInput;
import java.util.Objects;

class MemoryInput
implements TrinoInput {
    private final String location;
    private final Slice data;

    public MemoryInput(String location, Slice data) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.data = Objects.requireNonNull(data, "data is null");
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        this.data.getBytes(Math.toIntExact(position), buffer, bufferOffset, bufferLength);
    }

    @Override
    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) {
        int readSize = Math.min(this.data.length(), bufferLength);
        this.readFully(this.data.length() - readSize, buffer, bufferOffset, readSize);
        return readSize;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.location;
    }
}

