/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.trino.parquet.ParquetDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.column.values.bloomfilter.BlockSplitBloomFilter;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.format.BloomFilterHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.ParquetDecodingException;

public class BloomFilterStore {
    private static final int MAX_HEADER_LENGTH = 64;
    private final ParquetDataSource dataSource;
    private final Map<ColumnPath, Long> bloomFilterOffsets;

    public BloomFilterStore(ParquetDataSource dataSource, BlockMetaData block, Set<ColumnPath> columnsFiltered) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        Objects.requireNonNull(block, "block is null");
        Objects.requireNonNull(columnsFiltered, "columnsFiltered is null");
        ImmutableMap.Builder bloomFilterOffsetBuilder = ImmutableMap.builder();
        for (ColumnChunkMetaData column : block.getColumns()) {
            ColumnPath path = column.getPath();
            if (!BloomFilterStore.hasBloomFilter(column) || !columnsFiltered.contains(path)) continue;
            bloomFilterOffsetBuilder.put((Object)path, (Object)column.getBloomFilterOffset());
        }
        this.bloomFilterOffsets = bloomFilterOffsetBuilder.buildOrThrow();
    }

    public Optional<BloomFilter> getBloomFilter(ColumnPath columnPath) {
        long bloomFilterDataOffset;
        BloomFilterHeader bloomFilterHeader;
        try {
            Long columnBloomFilterOffset = this.bloomFilterOffsets.get(columnPath);
            if (columnBloomFilterOffset == null) {
                return Optional.empty();
            }
            BasicSliceInput headerSliceInput = this.dataSource.readFully(columnBloomFilterOffset, 64).getInput();
            bloomFilterHeader = Util.readBloomFilterHeader((InputStream)headerSliceInput);
            bloomFilterDataOffset = columnBloomFilterOffset + headerSliceInput.position();
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Failed to read Bloom filter header", exception);
        }
        if (!BloomFilterStore.bloomFilterSupported(columnPath, bloomFilterHeader)) {
            return Optional.empty();
        }
        try {
            Slice bloomFilterData = this.dataSource.readFully(bloomFilterDataOffset, bloomFilterHeader.getNumBytes());
            Verify.verify((bloomFilterData.length() > 0 ? 1 : 0) != 0, (String)"Read empty bloom filter %s", (Object)bloomFilterHeader);
            return Optional.of(new BlockSplitBloomFilter(bloomFilterData.getBytes()));
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Failed to read Bloom filter data", exception);
        }
    }

    public static boolean hasBloomFilter(ColumnChunkMetaData columnMetaData) {
        return columnMetaData.getBloomFilterOffset() > 0L;
    }

    private static boolean bloomFilterSupported(ColumnPath columnPath, BloomFilterHeader bloomFilterHeader) {
        int numBytes = bloomFilterHeader.getNumBytes();
        if (numBytes <= 0 || numBytes > 0x8000000) {
            throw new ParquetDecodingException(String.format("Column: %s has bloom filter number of bytes value of %d, which is out of bound of lower limit: %d and upper limit: %d", columnPath, numBytes, 0, 0x8000000));
        }
        return bloomFilterHeader.getHash().isSetXXHASH() && bloomFilterHeader.getAlgorithm().isSetBLOCK() && bloomFilterHeader.getCompression().isSetUNCOMPRESSED();
    }
}

