/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.repdef;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.repdef.DefLevelWriterProvider;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.ColumnarRow;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.column.values.ValuesWriter;

public class DefLevelWriterProviders {
    private DefLevelWriterProviders() {
    }

    public static DefLevelWriterProvider of(Block block, int maxDefinitionLevel) {
        return new PrimitiveDefLevelWriterProvider(block, maxDefinitionLevel);
    }

    public static DefLevelWriterProvider of(ColumnarRow columnarRow, int maxDefinitionLevel) {
        return new ColumnRowDefLevelWriterProvider(columnarRow, maxDefinitionLevel);
    }

    public static DefLevelWriterProvider of(ColumnarArray columnarArray, int maxDefinitionLevel) {
        return new ColumnArrayDefLevelWriterProvider(columnarArray, maxDefinitionLevel);
    }

    public static DefLevelWriterProvider of(ColumnarMap columnarMap, int maxDefinitionLevel) {
        return new ColumnMapDefLevelWriterProvider(columnarMap, maxDefinitionLevel);
    }

    private static void checkValidPosition(int offset, int positionsCount, int totalPositionsCount) {
        if (offset < 0 || positionsCount < 0 || offset + positionsCount > totalPositionsCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid offset %s and positionsCount %s in block with %s positions", offset, positionsCount, totalPositionsCount));
        }
    }

    static class PrimitiveDefLevelWriterProvider
    implements DefLevelWriterProvider {
        private final Block block;
        private final int maxDefinitionLevel;

        PrimitiveDefLevelWriterProvider(Block block, int maxDefinitionLevel) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelWriterProvider.DefinitionLevelWriter getDefinitionLevelWriter(Optional<DefLevelWriterProvider.DefinitionLevelWriter> nestedWriter, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriter.isEmpty(), (Object)"nestedWriter should be empty for primitive definition level writer");
            return new DefLevelWriterProvider.DefinitionLevelWriter(){
                private int offset;

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels() {
                    return this.writeDefinitionLevels(block.getPositionCount());
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels(int positionsCount) {
                    DefLevelWriterProviders.checkValidPosition(this.offset, positionsCount, block.getPositionCount());
                    int nonNullsCount = 0;
                    if (!block.mayHaveNull()) {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            encoder.writeInteger(maxDefinitionLevel);
                        }
                        nonNullsCount = positionsCount;
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            int isNull = block.isNull(position) ? 1 : 0;
                            encoder.writeInteger(maxDefinitionLevel - isNull);
                            nonNullsCount += isNull ^ 1;
                        }
                    }
                    this.offset += positionsCount;
                    return new DefLevelWriterProvider.ValuesCount(positionsCount, nonNullsCount);
                }
            };
        }
    }

    static class ColumnRowDefLevelWriterProvider
    implements DefLevelWriterProvider {
        private final ColumnarRow columnarRow;
        private final int maxDefinitionLevel;

        ColumnRowDefLevelWriterProvider(ColumnarRow columnarRow, int maxDefinitionLevel) {
            this.columnarRow = Objects.requireNonNull(columnarRow, "columnarRow is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelWriterProvider.DefinitionLevelWriter getDefinitionLevelWriter(final Optional<DefLevelWriterProvider.DefinitionLevelWriter> nestedWriterOptional, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column row definition level writer");
            return new DefLevelWriterProvider.DefinitionLevelWriter(){
                private final DefLevelWriterProvider.DefinitionLevelWriter nestedWriter;
                private int offset;
                {
                    this.nestedWriter = (DefLevelWriterProvider.DefinitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels() {
                    return this.writeDefinitionLevels(columnarRow.getPositionCount());
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels(int positionsCount) {
                    DefLevelWriterProviders.checkValidPosition(this.offset, positionsCount, columnarRow.getPositionCount());
                    if (!columnarRow.mayHaveNull()) {
                        this.offset += positionsCount;
                        return this.nestedWriter.writeDefinitionLevels(positionsCount);
                    }
                    int maxDefinitionValuesCount = 0;
                    int totalValuesCount = 0;
                    int position = this.offset;
                    while (position < this.offset + positionsCount) {
                        if (columnarRow.isNull(position)) {
                            encoder.writeInteger(maxDefinitionLevel - 1);
                            ++totalValuesCount;
                            ++position;
                            continue;
                        }
                        int consecutiveNonNullsCount = 1;
                        ++position;
                        while (position < this.offset + positionsCount && !columnarRow.isNull(position)) {
                            ++position;
                            ++consecutiveNonNullsCount;
                        }
                        DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(consecutiveNonNullsCount);
                        maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                        totalValuesCount += valuesCount.totalValuesCount();
                    }
                    this.offset += positionsCount;
                    return new DefLevelWriterProvider.ValuesCount(totalValuesCount, maxDefinitionValuesCount);
                }
            };
        }
    }

    static class ColumnArrayDefLevelWriterProvider
    implements DefLevelWriterProvider {
        private final ColumnarArray columnarArray;
        private final int maxDefinitionLevel;

        ColumnArrayDefLevelWriterProvider(ColumnarArray columnarArray, int maxDefinitionLevel) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelWriterProvider.DefinitionLevelWriter getDefinitionLevelWriter(final Optional<DefLevelWriterProvider.DefinitionLevelWriter> nestedWriterOptional, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column map definition level writer");
            return new DefLevelWriterProvider.DefinitionLevelWriter(){
                private final DefLevelWriterProvider.DefinitionLevelWriter nestedWriter;
                private int offset;
                {
                    this.nestedWriter = (DefLevelWriterProvider.DefinitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels() {
                    return this.writeDefinitionLevels(columnarArray.getPositionCount());
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels(int positionsCount) {
                    DefLevelWriterProviders.checkValidPosition(this.offset, positionsCount, columnarArray.getPositionCount());
                    int maxDefinitionValuesCount = 0;
                    int totalValuesCount = 0;
                    if (!columnarArray.mayHaveNull()) {
                        int position = this.offset;
                        while (position < this.offset + positionsCount) {
                            int arrayLength = columnarArray.getLength(position);
                            if (arrayLength == 0) {
                                encoder.writeInteger(maxDefinitionLevel - 1);
                                ++totalValuesCount;
                                ++position;
                                continue;
                            }
                            int consecutiveNonEmptyArrayLength = arrayLength;
                            ++position;
                            while (position < this.offset + positionsCount && (arrayLength = columnarArray.getLength(position)) != 0) {
                                ++position;
                                consecutiveNonEmptyArrayLength += arrayLength;
                            }
                            DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(consecutiveNonEmptyArrayLength);
                            maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                            totalValuesCount += valuesCount.totalValuesCount();
                        }
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            if (columnarArray.isNull(position)) {
                                encoder.writeInteger(maxDefinitionLevel - 2);
                                ++totalValuesCount;
                                continue;
                            }
                            int arrayLength = columnarArray.getLength(position);
                            if (arrayLength == 0) {
                                encoder.writeInteger(maxDefinitionLevel - 1);
                                ++totalValuesCount;
                                continue;
                            }
                            DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(arrayLength);
                            maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                            totalValuesCount += valuesCount.totalValuesCount();
                        }
                    }
                    this.offset += positionsCount;
                    return new DefLevelWriterProvider.ValuesCount(totalValuesCount, maxDefinitionValuesCount);
                }
            };
        }
    }

    static class ColumnMapDefLevelWriterProvider
    implements DefLevelWriterProvider {
        private final ColumnarMap columnarMap;
        private final int maxDefinitionLevel;

        ColumnMapDefLevelWriterProvider(ColumnarMap columnarMap, int maxDefinitionLevel) {
            this.columnarMap = Objects.requireNonNull(columnarMap, "columnarMap is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelWriterProvider.DefinitionLevelWriter getDefinitionLevelWriter(final Optional<DefLevelWriterProvider.DefinitionLevelWriter> nestedWriterOptional, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column map definition level writer");
            return new DefLevelWriterProvider.DefinitionLevelWriter(){
                private final DefLevelWriterProvider.DefinitionLevelWriter nestedWriter;
                private int offset;
                {
                    this.nestedWriter = (DefLevelWriterProvider.DefinitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels() {
                    return this.writeDefinitionLevels(columnarMap.getPositionCount());
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels(int positionsCount) {
                    DefLevelWriterProviders.checkValidPosition(this.offset, positionsCount, columnarMap.getPositionCount());
                    int maxDefinitionValuesCount = 0;
                    int totalValuesCount = 0;
                    if (!columnarMap.mayHaveNull()) {
                        int position = this.offset;
                        while (position < this.offset + positionsCount) {
                            int mapLength = columnarMap.getEntryCount(position);
                            if (mapLength == 0) {
                                encoder.writeInteger(maxDefinitionLevel - 1);
                                ++totalValuesCount;
                                ++position;
                                continue;
                            }
                            int consecutiveNonEmptyArrayLength = mapLength;
                            ++position;
                            while (position < this.offset + positionsCount && (mapLength = columnarMap.getEntryCount(position)) != 0) {
                                ++position;
                                consecutiveNonEmptyArrayLength += mapLength;
                            }
                            DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(consecutiveNonEmptyArrayLength);
                            maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                            totalValuesCount += valuesCount.totalValuesCount();
                        }
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            if (columnarMap.isNull(position)) {
                                encoder.writeInteger(maxDefinitionLevel - 2);
                                ++totalValuesCount;
                                continue;
                            }
                            int mapLength = columnarMap.getEntryCount(position);
                            if (mapLength == 0) {
                                encoder.writeInteger(maxDefinitionLevel - 1);
                                ++totalValuesCount;
                                continue;
                            }
                            DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(mapLength);
                            maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                            totalValuesCount += valuesCount.totalValuesCount();
                        }
                    }
                    this.offset += positionsCount;
                    return new DefLevelWriterProvider.ValuesCount(totalValuesCount, maxDefinitionValuesCount);
                }
            };
        }
    }
}

