/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.Session;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsProvider;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.cost.TableStatsProvider;
import io.trino.matching.Pattern;
import io.trino.spi.type.BigintType;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Patterns;
import java.util.Optional;

public class AssignUniqueIdStatsRule
implements ComposableStatsCalculator.Rule<AssignUniqueId> {
    private static final Pattern<AssignUniqueId> PATTERN = Patterns.assignUniqueId();

    @Override
    public Pattern<AssignUniqueId> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(AssignUniqueId assignUniqueId, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types, TableStatsProvider tableStatsProvider) {
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(assignUniqueId.getSource());
        return Optional.of(PlanNodeStatsEstimate.buildFrom(sourceStats).addSymbolStatistics(assignUniqueId.getIdColumn(), SymbolStatsEstimate.builder().setDistinctValuesCount(sourceStats.getOutputRowCount()).setNullsFraction(0.0).setAverageRowSize(BigintType.BIGINT.getFixedSize()).build()).build());
    }
}

