/*
 * Decompiled with CFR 0.152.
 */
package io.trino.dispatcher;

import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.dispatcher.DispatchExecutor;
import io.trino.dispatcher.FailedDispatchQuery;
import io.trino.event.QueryMonitor;
import io.trino.execution.LocationFactory;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.util.Failures;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;

public class FailedDispatchQueryFactory {
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final ExecutorService executor;
    private final NodeVersion version;

    @Inject
    public FailedDispatchQueryFactory(QueryMonitor queryMonitor, LocationFactory locationFactory, DispatchExecutor dispatchExecutor, NodeVersion version) {
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.executor = dispatchExecutor.getExecutor();
        this.version = Objects.requireNonNull(version, "version is null");
    }

    public FailedDispatchQuery createFailedDispatchQuery(Session session, String query, Optional<String> preparedQuery, Optional<ResourceGroupId> resourceGroup, Throwable throwable) {
        FailedDispatchQuery failedDispatchQuery = new FailedDispatchQuery(session, query, preparedQuery, this.locationFactory.createQueryLocation(session.getQueryId()), resourceGroup, throwable, this.executor, this.version);
        BasicQueryInfo queryInfo = failedDispatchQuery.getBasicQueryInfo();
        this.queryMonitor.queryCreatedEvent(queryInfo);
        this.queryMonitor.queryImmediateFailureEvent(queryInfo, Failures.toFailure(throwable));
        return failedDispatchQuery;
    }
}

