/*
 * Decompiled with CFR 0.152.
 */
package io.trino.exchange;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.exchange.ExchangeInput;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.spi.exchange.ExchangeSourceOutputSelector;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SpoolingExchangeInput
implements ExchangeInput {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SpoolingExchangeInput.class);
    private final List<ExchangeSourceHandle> exchangeSourceHandles;
    private final Optional<ExchangeSourceOutputSelector> outputSelector;

    @JsonCreator
    public SpoolingExchangeInput(@JsonProperty(value="exchangeSourceHandles") List<ExchangeSourceHandle> exchangeSourceHandles, @JsonProperty(value="outputSelector") Optional<ExchangeSourceOutputSelector> outputSelector) {
        this.exchangeSourceHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(exchangeSourceHandles, "exchangeSourceHandles is null"));
        this.outputSelector = Objects.requireNonNull(outputSelector, "outputSelector is null");
    }

    @JsonProperty
    public List<ExchangeSourceHandle> getExchangeSourceHandles() {
        return this.exchangeSourceHandles;
    }

    @JsonProperty
    public Optional<ExchangeSourceOutputSelector> getOutputSelector() {
        return this.outputSelector;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exchangeSourceHandles", this.exchangeSourceHandles).add("outputSelector", this.outputSelector).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.exchangeSourceHandles, ExchangeSourceHandle::getRetainedSizeInBytes) + SizeOf.sizeOf(this.outputSelector, ExchangeSourceOutputSelector::getRetainedSizeInBytes);
    }
}

