/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Throwables;
import io.airlift.concurrent.SetThreadName;
import io.trino.Session;
import io.trino.event.SplitMonitor;
import io.trino.execution.SqlTaskExecution;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.executor.TaskExecutor;
import io.trino.memory.QueryContext;
import io.trino.operator.TaskContext;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.TypeProvider;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SqlTaskExecutionFactory {
    private final Executor taskNotificationExecutor;
    private final TaskExecutor taskExecutor;
    private final LocalExecutionPlanner planner;
    private final SplitMonitor splitMonitor;
    private final boolean perOperatorCpuTimerEnabled;
    private final boolean cpuTimerEnabled;

    public SqlTaskExecutionFactory(Executor taskNotificationExecutor, TaskExecutor taskExecutor, LocalExecutionPlanner planner, SplitMonitor splitMonitor, TaskManagerConfig config) {
        this.taskNotificationExecutor = Objects.requireNonNull(taskNotificationExecutor, "taskNotificationExecutor is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
        this.planner = Objects.requireNonNull(planner, "planner is null");
        this.splitMonitor = Objects.requireNonNull(splitMonitor, "splitMonitor is null");
        this.perOperatorCpuTimerEnabled = config.isPerOperatorCpuTimerEnabled();
        this.cpuTimerEnabled = config.isTaskCpuTimerEnabled();
    }

    public SqlTaskExecution create(Session session, QueryContext queryContext, TaskStateMachine taskStateMachine, OutputBuffer outputBuffer, PlanFragment fragment, Runnable notifyStatusChanged) {
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan;
        TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, session, notifyStatusChanged, this.perOperatorCpuTimerEnabled, this.cpuTimerEnabled);
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{taskStateMachine.getTaskId()});){
            try {
                localExecutionPlan = this.planner.plan(taskContext, fragment.getRoot(), TypeProvider.copyOf(fragment.getSymbols()), fragment.getOutputPartitioningScheme(), fragment.getPartitionedSources(), outputBuffer);
            }
            catch (Throwable e) {
                taskStateMachine.failed(e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return new SqlTaskExecution(taskStateMachine, taskContext, outputBuffer, localExecutionPlan, this.taskExecutor, this.splitMonitor, this.taskNotificationExecutor);
    }
}

