/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.PipelinedBufferInfo;
import io.trino.operator.TaskStats;
import io.trino.sql.planner.plan.PlanNodeId;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class TaskInfo {
    private final TaskStatus taskStatus;
    private final DateTime lastHeartbeat;
    private final OutputBufferInfo outputBuffers;
    private final Set<PlanNodeId> noMoreSplits;
    private final TaskStats stats;
    private final Optional<DataSize> estimatedMemory;
    private final boolean needsPlan;

    @JsonCreator
    public TaskInfo(@JsonProperty(value="taskStatus") TaskStatus taskStatus, @JsonProperty(value="lastHeartbeat") DateTime lastHeartbeat, @JsonProperty(value="outputBuffers") OutputBufferInfo outputBuffers, @JsonProperty(value="noMoreSplits") Set<PlanNodeId> noMoreSplits, @JsonProperty(value="stats") TaskStats stats, @JsonProperty(value="estimatedMemory") Optional<DataSize> estimatedMemory, @JsonProperty(value="needsPlan") boolean needsPlan) {
        this.taskStatus = Objects.requireNonNull(taskStatus, "taskStatus is null");
        this.lastHeartbeat = Objects.requireNonNull(lastHeartbeat, "lastHeartbeat is null");
        this.outputBuffers = Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        this.noMoreSplits = Objects.requireNonNull(noMoreSplits, "noMoreSplits is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.estimatedMemory = Objects.requireNonNull(estimatedMemory, "estimatedMemory is null");
        this.needsPlan = needsPlan;
    }

    @JsonProperty
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    @JsonProperty
    public DateTime getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @JsonProperty
    public OutputBufferInfo getOutputBuffers() {
        return this.outputBuffers;
    }

    @JsonProperty
    public Set<PlanNodeId> getNoMoreSplits() {
        return this.noMoreSplits;
    }

    @JsonProperty
    public TaskStats getStats() {
        return this.stats;
    }

    @JsonProperty
    public Optional<DataSize> getEstimatedMemory() {
        return this.estimatedMemory;
    }

    @JsonProperty
    public boolean isNeedsPlan() {
        return this.needsPlan;
    }

    public TaskInfo summarize() {
        if (this.taskStatus.getState().isDone()) {
            return new TaskInfo(this.taskStatus, this.lastHeartbeat, this.outputBuffers.summarizeFinal(), this.noMoreSplits, this.stats.summarizeFinal(), this.estimatedMemory, this.needsPlan);
        }
        return new TaskInfo(this.taskStatus, this.lastHeartbeat, this.outputBuffers.summarize(), this.noMoreSplits, this.stats.summarize(), this.estimatedMemory, this.needsPlan);
    }

    public TaskInfo pruneSpoolingOutputStats() {
        return new TaskInfo(this.taskStatus, this.lastHeartbeat, this.outputBuffers.pruneSpoolingOutputStats(), this.noMoreSplits, this.stats, this.estimatedMemory, this.needsPlan);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskStatus.getTaskId()).add("state", (Object)this.taskStatus.getState()).toString();
    }

    public static TaskInfo createInitialTask(TaskId taskId, URI location, String nodeId, Optional<List<PipelinedBufferInfo>> pipelinedBufferStates, TaskStats taskStats) {
        return new TaskInfo(TaskStatus.initialTaskStatus(taskId, location, nodeId), DateTime.now(), new OutputBufferInfo("UNINITIALIZED", BufferState.OPEN, true, true, 0L, 0L, 0L, 0L, pipelinedBufferStates, Optional.empty(), Optional.empty()), (Set<PlanNodeId>)ImmutableSet.of(), taskStats, Optional.empty(), true);
    }

    public TaskInfo withTaskStatus(TaskStatus newTaskStatus) {
        return new TaskInfo(newTaskStatus, this.lastHeartbeat, this.outputBuffers, this.noMoreSplits, this.stats, this.estimatedMemory, this.needsPlan);
    }

    public TaskInfo withEstimatedMemory(DataSize estimatedMemory) {
        return new TaskInfo(this.taskStatus, this.lastHeartbeat, this.outputBuffers, this.noMoreSplits, this.stats, Optional.of(estimatedMemory), this.needsPlan);
    }
}

