/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.MoreObjects;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.spi.ErrorCode;
import java.util.Objects;
import java.util.Optional;

public interface PartitionMemoryEstimator {
    public MemoryRequirements getInitialMemoryRequirements(Session var1, DataSize var2);

    public MemoryRequirements getNextRetryMemoryRequirements(Session var1, MemoryRequirements var2, DataSize var3, ErrorCode var4);

    public void registerPartitionFinished(Session var1, MemoryRequirements var2, DataSize var3, boolean var4, Optional<ErrorCode> var5);

    public static class MemoryRequirements {
        private final DataSize requiredMemory;

        MemoryRequirements(DataSize requiredMemory) {
            this.requiredMemory = Objects.requireNonNull(requiredMemory, "requiredMemory is null");
        }

        public DataSize getRequiredMemory() {
            return this.requiredMemory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemoryRequirements that = (MemoryRequirements)o;
            return Objects.equals(this.requiredMemory, that.requiredMemory);
        }

        public int hashCode() {
            return Objects.hash(this.requiredMemory);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("requiredMemory", (Object)this.requiredMemory).toString();
        }
    }
}

