/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.json.ir.IrPredicate;
import java.util.Objects;

public class IrComparisonPredicate
extends IrPredicate {
    private final Operator operator;
    private final IrPathNode left;
    private final IrPathNode right;

    @JsonCreator
    public IrComparisonPredicate(@JsonProperty(value="operator") Operator operator, @JsonProperty(value="left") IrPathNode left, @JsonProperty(value="right") IrPathNode right) {
        this.operator = Objects.requireNonNull(operator, "operator is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrComparisonPredicate(this, context);
    }

    @JsonProperty
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty
    public IrPathNode getLeft() {
        return this.left;
    }

    @JsonProperty
    public IrPathNode getRight() {
        return this.right;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrComparisonPredicate other = (IrComparisonPredicate)obj;
        return this.operator == other.operator && Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        GREATER_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN_OR_EQUAL;

    }
}

