/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import io.airlift.units.DataSize;
import io.trino.memory.MemoryInfo;
import io.trino.memory.MemoryPool;
import io.trino.memory.NodeMemoryConfig;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import javax.inject.Inject;

public final class LocalMemoryManager {
    private static final OperatingSystemMXBean OPERATING_SYSTEM_MX_BEAN = ManagementFactory.getOperatingSystemMXBean();
    private final MemoryPool memoryPool;

    @Inject
    public LocalMemoryManager(NodeMemoryConfig config) {
        this(config, Runtime.getRuntime().maxMemory());
    }

    @VisibleForTesting
    LocalMemoryManager(NodeMemoryConfig config, long availableMemory) {
        this.validateHeapHeadroom(config, availableMemory);
        DataSize memoryPoolSize = DataSize.ofBytes((long)(availableMemory - config.getHeapHeadroom().toBytes()));
        Verify.verify((memoryPoolSize.toBytes() > 0L ? 1 : 0) != 0, (String)"memory pool size is 0", (Object[])new Object[0]);
        this.memoryPool = new MemoryPool(memoryPoolSize);
    }

    private void validateHeapHeadroom(NodeMemoryConfig config, long availableMemory) {
        long maxQueryTotalMemoryPerNode = config.getMaxQueryMemoryPerNode().toBytes();
        long heapHeadroom = config.getHeapHeadroom().toBytes();
        if (heapHeadroom < 0L || heapHeadroom + maxQueryTotalMemoryPerNode > availableMemory) {
            throw new IllegalArgumentException(String.format("Invalid memory configuration. The sum of max query memory per node (%s) and heap headroom (%s) cannot be larger than the available heap memory (%s)", maxQueryTotalMemoryPerNode, heapHeadroom, availableMemory));
        }
    }

    public MemoryInfo getInfo() {
        return new MemoryInfo(OPERATING_SYSTEM_MX_BEAN.getAvailableProcessors(), this.memoryPool.getInfo());
    }

    public MemoryPool getMemoryPool() {
        return this.memoryPool;
    }
}

