/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;

public class CatalogTransaction {
    private final CatalogHandle catalogHandle;
    private final Connector connector;
    private final ConnectorTransactionHandle transactionHandle;
    @GuardedBy(value="this")
    private ConnectorMetadata connectorMetadata;
    private final AtomicBoolean finished = new AtomicBoolean();

    public CatalogTransaction(CatalogHandle catalogHandle, Connector connector, ConnectorTransactionHandle transactionHandle) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
    }

    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    public boolean isSingleStatementWritesOnly() {
        return this.connector.isSingleStatementWritesOnly();
    }

    public synchronized ConnectorMetadata getConnectorMetadata(Session session) {
        Preconditions.checkState((!this.finished.get() ? 1 : 0) != 0, (Object)"Already finished");
        if (this.connectorMetadata == null) {
            ConnectorSession connectorSession = session.toConnectorSession(this.catalogHandle);
            this.connectorMetadata = this.connector.getMetadata(connectorSession, this.transactionHandle);
        }
        return this.connectorMetadata;
    }

    public ConnectorTransactionHandle getTransactionHandle() {
        Preconditions.checkState((!this.finished.get() ? 1 : 0) != 0, (Object)"Already finished");
        return this.transactionHandle;
    }

    public void commit() {
        if (this.finished.compareAndSet(false, true)) {
            this.connector.commit(this.transactionHandle);
        }
    }

    public void abort() {
        if (this.finished.compareAndSet(false, true)) {
            this.connector.rollback(this.transactionHandle);
        }
    }
}

