/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public final class TableHandle {
    private final CatalogHandle catalogHandle;
    private final ConnectorTableHandle connectorHandle;
    private final ConnectorTransactionHandle transaction;

    @JsonCreator
    public TableHandle(@JsonProperty(value="catalogHandle") CatalogHandle catalogHandle, @JsonProperty(value="connectorHandle") ConnectorTableHandle connectorHandle, @JsonProperty(value="transaction") ConnectorTransactionHandle transaction) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
    }

    @JsonProperty
    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    @JsonProperty
    public ConnectorTableHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    @JsonProperty
    public ConnectorTransactionHandle getTransaction() {
        return this.transaction;
    }

    public TableHandle withConnectorHandle(ConnectorTableHandle connectorHandle) {
        return new TableHandle(this.catalogHandle, connectorHandle, this.transaction);
    }

    public String toString() {
        return this.catalogHandle + ":" + this.connectorHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableHandle other = (TableHandle)o;
        return Objects.equals(this.catalogHandle, other.catalogHandle) && Objects.equals(this.connectorHandle, other.connectorHandle) && Objects.equals(this.transaction, other.transaction);
    }

    public int hashCode() {
        return Objects.hash(this.catalogHandle, this.connectorHandle, this.transaction);
    }
}

