/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.operator.TableFunctionPartition;
import io.trino.operator.WorkProcessor;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.ptf.TableFunctionDataProcessor;
import io.trino.spi.ptf.TableFunctionProcessorState;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class EmptyTableFunctionPartition
implements TableFunctionPartition {
    private final TableFunctionDataProcessor tableFunction;
    private final int properChannelsCount;
    private final int passThroughSourcesCount;
    private final Type[] passThroughTypes;

    public EmptyTableFunctionPartition(TableFunctionDataProcessor tableFunction, int properChannelsCount, int passThroughSourcesCount, List<Type> passThroughTypes) {
        this.tableFunction = Objects.requireNonNull(tableFunction, "tableFunction is null");
        this.properChannelsCount = properChannelsCount;
        this.passThroughSourcesCount = passThroughSourcesCount;
        this.passThroughTypes = passThroughTypes.toArray(new Type[0]);
    }

    @Override
    public WorkProcessor<Page> toOutputPages() {
        return WorkProcessor.create(() -> {
            TableFunctionProcessorState state = this.tableFunction.process(null);
            if (state == TableFunctionProcessorState.Finished.FINISHED) {
                return WorkProcessor.ProcessState.finished();
            }
            if (state instanceof TableFunctionProcessorState.Blocked) {
                TableFunctionProcessorState.Blocked blocked = (TableFunctionProcessorState.Blocked)state;
                return WorkProcessor.ProcessState.blocked((ListenableFuture<Void>)MoreFutures.toListenableFuture((CompletableFuture)blocked.getFuture()));
            }
            TableFunctionProcessorState.Processed processed = (TableFunctionProcessorState.Processed)state;
            if (processed.getResult() != null) {
                return WorkProcessor.ProcessState.ofResult(this.appendNullsForPassThroughColumns(processed.getResult()));
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "When function got no input, it should either produce output or return Blocked state");
        });
    }

    private Page appendNullsForPassThroughColumns(Page page) {
        int channel;
        if (page.getChannelCount() != this.properChannelsCount + this.passThroughSourcesCount) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Table function returned a page containing %s channels. Expected channel number: %s (%s proper columns, %s pass-through index columns)", page.getChannelCount(), this.properChannelsCount + this.passThroughSourcesCount, this.properChannelsCount, this.passThroughSourcesCount));
        }
        Block[] resultBlocks = new Block[this.properChannelsCount + this.passThroughTypes.length];
        for (channel = 0; channel < this.properChannelsCount; ++channel) {
            resultBlocks[channel] = page.getBlock(channel);
        }
        channel = this.properChannelsCount;
        for (Type type : this.passThroughTypes) {
            resultBlocks[channel] = RunLengthEncodedBlock.create((Type)type, null, (int)page.getPositionCount());
            ++channel;
        }
        return new Page(page.getPositionCount(), resultBlocks);
    }
}

