/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.metadata.Split;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.ptf.TableFunctionProcessorProvider;
import io.trino.spi.ptf.TableFunctionProcessorState;
import io.trino.spi.ptf.TableFunctionSplitProcessor;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class LeafTableFunctionOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final TableFunctionProcessorProvider tableFunctionProvider;
    private final ConnectorTableFunctionHandle functionHandle;
    private ConnectorSplit currentSplit;
    private final List<ConnectorSplit> pendingSplits = new ArrayList<ConnectorSplit>();
    private boolean noMoreSplits;
    private TableFunctionSplitProcessor processor;
    private boolean processorUsedData;
    private boolean processorFinishedSplit = true;
    private ListenableFuture<Void> processorBlocked = NOT_BLOCKED;

    public LeafTableFunctionOperator(OperatorContext operatorContext, PlanNodeId sourceId, TableFunctionProcessorProvider tableFunctionProvider, ConnectorTableFunctionHandle functionHandle) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.tableFunctionProvider = Objects.requireNonNull(tableFunctionProvider, "tableFunctionProvider is null");
        this.functionHandle = Objects.requireNonNull(functionHandle, "functionHandle is null");
    }

    private void resetProcessor() {
        this.processor = this.tableFunctionProvider.getSplitProcessor(this.functionHandle);
        this.processorUsedData = false;
        this.processorFinishedSplit = false;
        this.processorBlocked = NOT_BLOCKED;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not take input");
    }

    @Override
    public void addSplit(Split split) {
        Preconditions.checkState((!this.noMoreSplits ? 1 : 0) != 0, (Object)"no more splits expected");
        this.pendingSplits.add(split.getConnectorSplit());
    }

    @Override
    public void noMoreSplits() {
        this.noMoreSplits = true;
    }

    @Override
    public Page getOutput() {
        if (this.processorFinishedSplit) {
            if (this.pendingSplits.isEmpty()) {
                return null;
            }
            this.currentSplit = this.pendingSplits.remove(0);
            this.resetProcessor();
        } else {
            Objects.requireNonNull(this.currentSplit, "currentSplit is null");
        }
        TableFunctionProcessorState state = this.processor.process(this.processorUsedData ? null : this.currentSplit);
        if (state == TableFunctionProcessorState.Finished.FINISHED) {
            this.processorFinishedSplit = true;
        }
        if (state instanceof TableFunctionProcessorState.Blocked) {
            TableFunctionProcessorState.Blocked blocked = (TableFunctionProcessorState.Blocked)state;
            this.processorBlocked = MoreFutures.toListenableFuture((CompletableFuture)blocked.getFuture());
        }
        if (state instanceof TableFunctionProcessorState.Processed) {
            TableFunctionProcessorState.Processed processed = (TableFunctionProcessorState.Processed)state;
            if (processed.isUsedInput()) {
                this.processorUsedData = true;
            }
            if (processed.getResult() != null) {
                return processed.getResult();
            }
        }
        return null;
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        return this.processorBlocked;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isFinished() {
        return this.processorFinishedSplit && this.pendingSplits.isEmpty() && this.noMoreSplits;
    }

    @Override
    public void close() throws Exception {
    }

    public static class LeafTableFunctionOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final TableFunctionProcessorProvider tableFunctionProvider;
        private final ConnectorTableFunctionHandle functionHandle;
        private boolean closed;

        public LeafTableFunctionOperatorFactory(int operatorId, PlanNodeId sourceId, TableFunctionProcessorProvider tableFunctionProvider, ConnectorTableFunctionHandle functionHandle) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.tableFunctionProvider = Objects.requireNonNull(tableFunctionProvider, "tableFunctionProvider is null");
            this.functionHandle = Objects.requireNonNull(functionHandle, "functionHandle is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, LeafTableFunctionOperator.class.getSimpleName());
            return new LeafTableFunctionOperator(operatorContext, this.sourceId, this.tableFunctionProvider, this.functionHandle);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

