/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.PageUtils;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorSourceOperator;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.metrics.Metrics;
import io.trino.split.EmptySplit;
import io.trino.split.PageSourceProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class TableScanWorkProcessorOperator
implements WorkProcessorSourceOperator {
    private final WorkProcessor<Page> pages;
    private final SplitToPages splitToPages;

    public TableScanWorkProcessorOperator(Session session, MemoryTrackingContext memoryTrackingContext, WorkProcessor<Split> splits, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        this.splitToPages = new SplitToPages(session, pageSourceProvider, table, columns, dynamicFilter, memoryTrackingContext.aggregateUserMemoryContext());
        this.pages = splits.flatTransform(this.splitToPages);
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public DataSize getPhysicalInputDataSize() {
        return this.splitToPages.getPhysicalInputDataSize();
    }

    @Override
    public long getPhysicalInputPositions() {
        return this.splitToPages.getPhysicalInputPositions();
    }

    @Override
    public DataSize getInputDataSize() {
        return this.splitToPages.getInputDataSize();
    }

    @Override
    public long getInputPositions() {
        return this.splitToPages.getInputPositions();
    }

    @Override
    public long getDynamicFilterSplitsProcessed() {
        return this.splitToPages.getDynamicFilterSplitsProcessed();
    }

    @Override
    public Metrics getConnectorMetrics() {
        return this.splitToPages.source.getMetrics();
    }

    @Override
    public Duration getReadTime() {
        return this.splitToPages.getReadTime();
    }

    @Override
    public void close() {
        this.splitToPages.close();
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    private static class SplitToPages
    implements WorkProcessor.Transformation<Split, WorkProcessor<Page>> {
        final Session session;
        final PageSourceProvider pageSourceProvider;
        final TableHandle table;
        final List<ColumnHandle> columns;
        final DynamicFilter dynamicFilter;
        final LocalMemoryContext memoryContext;
        long processedBytes;
        long processedPositions;
        long dynamicFilterSplitsProcessed;
        @Nullable
        ConnectorPageSource source;

        SplitToPages(Session session, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns, DynamicFilter dynamicFilter, AggregatedMemoryContext aggregatedMemoryContext) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
            this.memoryContext = aggregatedMemoryContext.newLocalMemoryContext(TableScanWorkProcessorOperator.class.getSimpleName());
        }

        @Override
        public WorkProcessor.TransformationState<WorkProcessor<Page>> process(Split split) {
            if (split == null) {
                this.memoryContext.close();
                return WorkProcessor.TransformationState.finished();
            }
            if (!this.dynamicFilter.getCurrentPredicate().isAll()) {
                ++this.dynamicFilterSplitsProcessed;
            }
            this.source = split.getConnectorSplit() instanceof EmptySplit ? new EmptyPageSource() : this.pageSourceProvider.createPageSource(this.session, split, this.table, this.columns, this.dynamicFilter);
            return WorkProcessor.TransformationState.ofResult(WorkProcessor.create(new ConnectorPageSourceToPages(this.source)).map(page -> {
                this.processedPositions += (long)page.getPositionCount();
                PageUtils.recordMaterializedBytes(page, sizeInBytes -> this.processedBytes += sizeInBytes);
                return page;
            }).blocking(() -> this.memoryContext.setBytes(this.source.getMemoryUsage())));
        }

        DataSize getPhysicalInputDataSize() {
            if (this.source == null) {
                return DataSize.ofBytes((long)0L);
            }
            return DataSize.ofBytes((long)this.source.getCompletedBytes());
        }

        long getPhysicalInputPositions() {
            if (this.source == null) {
                return 0L;
            }
            return this.source.getCompletedPositions().orElse(this.processedPositions);
        }

        DataSize getInputDataSize() {
            return DataSize.ofBytes((long)this.processedBytes);
        }

        long getInputPositions() {
            return this.processedPositions;
        }

        long getDynamicFilterSplitsProcessed() {
            return this.dynamicFilterSplitsProcessed;
        }

        Duration getReadTime() {
            if (this.source == null) {
                return new Duration(0.0, TimeUnit.NANOSECONDS);
            }
            return new Duration((double)this.source.getReadTimeNanos(), TimeUnit.NANOSECONDS);
        }

        void close() {
            if (this.source != null) {
                try {
                    this.source.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private static class ConnectorPageSourceToPages
    implements WorkProcessor.Process<Page> {
        final ConnectorPageSource pageSource;

        ConnectorPageSourceToPages(ConnectorPageSource pageSource) {
            this.pageSource = pageSource;
        }

        @Override
        public WorkProcessor.ProcessState<Page> process() {
            if (this.pageSource.isFinished()) {
                return WorkProcessor.ProcessState.finished();
            }
            CompletableFuture isBlocked = this.pageSource.isBlocked();
            if (!isBlocked.isDone()) {
                return WorkProcessor.ProcessState.blocked(TableScanWorkProcessorOperator.asVoid(MoreFutures.toListenableFuture((CompletableFuture)isBlocked)));
            }
            Page page = this.pageSource.getNextPage();
            if (page == null) {
                if (this.pageSource.isFinished()) {
                    return WorkProcessor.ProcessState.finished();
                }
                return WorkProcessor.ProcessState.yielded();
            }
            return WorkProcessor.ProcessState.ofResult(page);
        }
    }
}

