/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.NullablePosition;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InOut;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import java.lang.invoke.MethodHandle;

@AggregationFunction(value="max_by")
@Description(value="Returns the value of the first argument, associated with the maximum value of the second argument")
public final class MaxByAggregationFunction {
    private MaxByAggregationFunction() {
    }

    @InputFunction
    @TypeParameters(value={@TypeParameter(value="V"), @TypeParameter(value="K")})
    public static void input(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.IN_OUT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compare, @AggregationState(value={"K"}) InOut keyState, @AggregationState(value={"V"}) InOut valueState, @NullablePosition @BlockPosition @SqlType(value="V") Block valueBlock, @BlockPosition @SqlType(value="K") Block keyBlock, @BlockIndex int position) throws Throwable {
        if (keyState.isNull() || compare.invokeExact(keyBlock, position, keyState) > 0L) {
            keyState.set(keyBlock, position);
            valueState.set(valueBlock, position);
        }
    }

    @CombineFunction
    public static void combine(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.IN_OUT, InvocationConvention.InvocationArgumentConvention.IN_OUT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compare, @AggregationState(value={"K"}) InOut keyState, @AggregationState(value={"V"}) InOut valueState, @AggregationState(value={"K"}) InOut otherKeyState, @AggregationState(value={"V"}) InOut otherValueState) throws Throwable {
        if (otherKeyState.isNull()) {
            return;
        }
        if (keyState.isNull() || compare.invokeExact(otherKeyState, keyState) > 0L) {
            keyState.set(otherKeyState);
            valueState.set(otherValueState);
        }
    }

    @OutputFunction(value="V")
    public static void output(@AggregationState(value={"K"}) InOut keyState, @AggregationState(value={"V"}) InOut valueState, BlockBuilder out) {
        valueState.get(out);
    }
}

