/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.SizeOf;
import io.airlift.stats.cardinality.HyperLogLog;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.operator.aggregation.state.HyperLogLogState;
import io.trino.spi.function.AccumulatorStateFactory;
import java.util.Objects;

public class HyperLogLogStateFactory
implements AccumulatorStateFactory<HyperLogLogState> {
    public HyperLogLogState createSingleState() {
        return new SingleHyperLogLogState();
    }

    public HyperLogLogState createGroupedState() {
        return new GroupedHyperLogLogState();
    }

    public static class SingleHyperLogLogState
    implements HyperLogLogState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleHyperLogLogState.class);
        private HyperLogLog hll;

        @Override
        public HyperLogLog getHyperLogLog() {
            return this.hll;
        }

        @Override
        public void setHyperLogLog(HyperLogLog value) {
            this.hll = value;
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.hll != null) {
                estimatedSize += (long)this.hll.estimatedInMemorySize();
            }
            return estimatedSize;
        }
    }

    public static class GroupedHyperLogLogState
    extends AbstractGroupedAccumulatorState
    implements HyperLogLogState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedHyperLogLogState.class);
        private final ObjectBigArray<HyperLogLog> hlls = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.hlls.ensureCapacity(size);
        }

        @Override
        public HyperLogLog getHyperLogLog() {
            return (HyperLogLog)this.hlls.get(this.getGroupId());
        }

        @Override
        public void setHyperLogLog(HyperLogLog value) {
            Objects.requireNonNull(value, "value is null");
            this.hlls.set(this.getGroupId(), (Object)value);
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.hlls.sizeOf();
        }
    }
}

