/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.KeyValuePairs;
import io.trino.operator.aggregation.state.KeyValuePairsState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Objects;

public class KeyValuePairStateSerializer
implements AccumulatorStateSerializer<KeyValuePairsState> {
    private final Type mapType;
    private final BlockTypeOperators.BlockPositionEqual keyEqual;
    private final BlockTypeOperators.BlockPositionHashCode keyHashCode;

    public KeyValuePairStateSerializer(@TypeParameter(value="MAP(K, V)") Type mapType, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) BlockTypeOperators.BlockPositionEqual keyEqual, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode keyHashCode) {
        this.mapType = Objects.requireNonNull(mapType, "mapType is null");
        this.keyEqual = Objects.requireNonNull(keyEqual, "keyEqual is null");
        this.keyHashCode = Objects.requireNonNull(keyHashCode, "keyHashCode is null");
    }

    public Type getSerializedType() {
        return this.mapType;
    }

    public void serialize(KeyValuePairsState state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            state.get().serialize(out);
        }
    }

    public void deserialize(Block block, int index, KeyValuePairsState state) {
        state.set(new KeyValuePairs((Block)this.mapType.getObject(block, index), state.getKeyType(), this.keyEqual, this.keyHashCode, state.getValueType()));
    }
}

